/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.util;

import java.util.HashMap;
import java.util.Map;

import com.clustercontrol.monitor.bean.EventTableDefine;
import com.clustercontrol.monitor.run.bean.MonitorTabelDefine;
import com.clustercontrol.monitor.run.bean.StringValueListTabelDefine;

/**
 * 
 **/
public class MonitorMappingUtil {

    private static final Map<Integer, String> EVENT_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
		 * 
		 */
        private static final long serialVersionUID = -6098871711845747731L;

        {
            put(EventTableDefine.PRIORITY, "priority");
            put(EventTableDefine.RECEIVE_TIME, "receiveTime");
            put(EventTableDefine.OUTPUT_DATE, "outputDate");
            put(EventTableDefine.PLUGIN_ID, "pluginId");
            put(EventTableDefine.MONITOR_ID, "monitorId");
            put(EventTableDefine.FACILITY_ID, "facilityId");
            put(EventTableDefine.SCOPE, "scope");
            put(EventTableDefine.APPLICATION, "application");
            put(EventTableDefine.MESSAGE_ID, "messageId");
            put(EventTableDefine.MESSAGE, "message");
            put(EventTableDefine.CONFIRMED, "confirmed");
            put(EventTableDefine.CONFIRM_USER, "confirmUser");
        }
    };

    private static final Map<Integer, String> MONITOR_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
		 * 
		 */
        private static final long serialVersionUID = -6098871711845747731L;

        {
            put(MonitorTabelDefine.MONITOR_ID, "monitorId");
            put(MonitorTabelDefine.DESCRIPTION, "description");
            put(MonitorTabelDefine.FACILITY_ID, "facilityId");
            put(MonitorTabelDefine.MONITOR_TYPE, "monitorType");
            put(MonitorTabelDefine.CALENDAR_ID, "calendarId");
            put(MonitorTabelDefine.RUN_INTERVAL, "runInterval");
            put(MonitorTabelDefine.VALID_FLG, "validFlag");
            put(MonitorTabelDefine.CREATE_USER, "createUser");
            put(MonitorTabelDefine.CREATE_TIME, "createTime");
            put(MonitorTabelDefine.UPDATE_USER, "updateUser");
            put(MonitorTabelDefine.UPDATE_TIME, "updateTime");
        }
    };

    private static final Map<Integer, String> STRING_VALUE_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
		 * 
		 */
        private static final long serialVersionUID = -6098871711845747731L;

        {
            put(StringValueListTabelDefine.ORDER_NO, "orderNo");
            put(StringValueListTabelDefine.PROCESS_TYPE, "processType");
            put(StringValueListTabelDefine.DESCRIPTION, "description");
            put(StringValueListTabelDefine.VALID_FLG, "validFlg");
            put(StringValueListTabelDefine.MESSAGE_ID, "messageId");
        }
    };

    public static final String getEventName(int id) {
        return EVENT_COLUMN_NAME_MAP.get(id);
    }

    public static final String getMonitorName(int id) {
        return MONITOR_COLUMN_NAME_MAP.get(id);
    }

    public static final String getStringValue(int id) {
        return STRING_VALUE_COLUMN_NAME_MAP.get(id);
    }
}