/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.monitor.bean.ScopeTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.Constants;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebHeaderInvalidException;
import com.necsoft.hinemos.webclient.json.GridHeaderJson;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.monitor.MonitorConstants;
import com.necsoft.hinemos.webclient.monitor.action.GetScopeListTableDefine;
import com.necsoft.hinemos.webclient.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

public class GetScopeListTableDefineBusiness {

    public ArrayList<TableColumnInfoJs> getScopeListTableDefine(Locale locale)
            throws HinemosWebException {
        // 中間変数を宣言
        ArrayList<TableColumnInfoJs> tblDefine = null;

        // イベントテーブルヘッダー定義データ(ScopeTableDefine)を取得
        tblDefine = GetScopeListTableDefine.getScopeListTableDefine(locale);

        // イベントテーブルヘッダー定義データの項目数チェック
        if (tblDefine.size() != MonitorConstants.NUMBER_HEADER_SCOPE) {
            // 項目数が不足の場合
            throw new HinemosWebHeaderInvalidException(
                    "exception.monitor.scope.header.number");
        }
        return tblDefine;
    }

    public GridHeaderJson doConvertToJson(
            ArrayList<TableColumnInfoJs> tblDefine, Locale locale) {
        // Create JSON
        GridHeaderJson result = new GridHeaderJson();
        result.setColNames(ConvertListUtil.columnInfoToColNames(tblDefine));
        result.setColModel(ConvertListUtil.columnInfoToColModel(tblDefine));

        result.setRowNum(Constants.MONITOR_SCOPE_ROW_NUM);
        result.setSortname(ScopeTableDefine.SORT_COLUMN_INDEX);
        result.setSortorder(SortOrderUtil
                .getJsString(ScopeTableDefine.SORT_ORDER));
        result.setRecordtext(WebMessages.getString("records",
                new Object[] { "{1}" }, locale));
        result.setEmptyrecords(WebMessages.getString("records",
                new Object[] { "0" }, locale));
        return result;
    }

}
