/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.util;

import java.util.HashMap;
import java.util.Map;

import com.clustercontrol.jobmanagement.bean.HistoryTableDefine;
import com.clustercontrol.jobmanagement.bean.JobDetailTableDefine;
import com.clustercontrol.jobmanagement.bean.JobTableDefine;
import com.clustercontrol.jobmanagement.bean.RunScheduleDetailListTableDefine;
import com.clustercontrol.jobmanagement.bean.RunScheduleListTableDefine;

/**
 * This class used for Mapping data
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class JobMappingUtil {
    private static final Map<Integer, String> JOB_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
         * 
         */
        private static final long serialVersionUID = 7261193083575860188L;

        {
            put(JobTableDefine.JOB_ID, "jobId");
            put(JobTableDefine.JOB_NAME, "jobName");
            put(JobTableDefine.JOB_TYPE, "jobType");
            put(JobTableDefine.FACILITY_ID, "facilityId");
            put(JobTableDefine.SCOPE, "scope");
            put(JobTableDefine.WAIT_RULE, "waitRule");
            put(JobTableDefine.CREATE_USER, "createUser");
            put(JobTableDefine.CREATE_TIME, "createTime");
            put(JobTableDefine.UPDATE_USER, "updateUser");
            put(JobTableDefine.UPDATE_TIME, "updateTime");
        }
    };

    private static final Map<Integer, String> HISTORY_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
		 * 
		 */
        private static final long serialVersionUID = -6098871711845747731L;

        {
            put(HistoryTableDefine.STATUS, "status");
            put(HistoryTableDefine.END_STATUS, "endStatus");
            put(HistoryTableDefine.END_VALUE, "endValue");
            put(HistoryTableDefine.SESSION_ID, "sessionId");
            put(HistoryTableDefine.JOB_ID, "jobId");
            put(HistoryTableDefine.JOB_NAME, "jobName");
            put(HistoryTableDefine.JOBUNIT_ID, "jobuinitId");
            put(HistoryTableDefine.JOB_TYPE, "jobType");
            put(HistoryTableDefine.FACILITY_ID, "messageId");
            put(HistoryTableDefine.SCOPE, "scope");
            put(HistoryTableDefine.SCHEDULED_START_TIME, "scheduledStartTime");
            put(HistoryTableDefine.START_RERUN_TIME, "startReturnTime");
            put(HistoryTableDefine.END_SUSPEND_TIME, "endSuspendTime");
            put(HistoryTableDefine.TRIGGER_TYPE, "triggerType");
            put(HistoryTableDefine.TRIGGER_INFO, "triggerInfo");
        }
    };

    private static final Map<Integer, String> JOB_DETAIL_COLUMN_NAME_MAP = new HashMap<Integer, String>() {

        /**
		 * 
		 */
        private static final long serialVersionUID = 4862213824718976924L;

        {
            put(JobDetailTableDefine.TREE, "tree");
            put(JobDetailTableDefine.STATUS, "status");
            put(JobDetailTableDefine.END_STATUS, "endStatus");
            put(JobDetailTableDefine.END_VALUE, "endValue");
            put(JobDetailTableDefine.JOB_ID, "jobId");
            put(JobDetailTableDefine.JOB_NAME, "jobName");
            put(JobDetailTableDefine.JOBUNIT_ID, "jobunitId");
            put(JobDetailTableDefine.JOB_TYPE, "jobType");
            put(JobDetailTableDefine.FACILITY_ID, "facilityId");
            put(JobDetailTableDefine.SCOPE, "scope");
            put(JobDetailTableDefine.WAIT_RULE_TIME, "waitRuleTime");
            put(JobDetailTableDefine.START_RERUN_TIME, "startRerunTime");
            put(JobDetailTableDefine.END_SUSPEND_TIME, "endSuspendTime");
        }
    };

    private static final Map<Integer, String> RUN_SCHEDULE_LIST_COLUMN_NAME_MAP = new HashMap<Integer, String>() {

        /**
		 * 
		 */
        private static final long serialVersionUID = -3870951354521504860L;
        {
            put(RunScheduleListTableDefine.SCHE_ID, "scheduleId");
            put(RunScheduleListTableDefine.SCHE_NAME, "scheduleName");
            put(RunScheduleListTableDefine.JOB_ID, "jobId");
            put(RunScheduleListTableDefine.JOB_NAME, "jobName");
            put(RunScheduleListTableDefine.JOBUNIT_ID, "jobunitId");
            put(RunScheduleListTableDefine.CALENDAR_ID, "calendarId");
            // put(RunScheduleListTableDefine.CALENDAR_ID + 1,
            // "calendarIdPlusOne");
        }
    };

    private static final Map<Integer, String> RUN_SCHEDULE_DETAIL_LIST_COLUMN_NAME_MAP = new HashMap<Integer, String>() {

        /**
         * 
         */
        private static final long serialVersionUID = -1725243838685715676L;

        {
            put(RunScheduleDetailListTableDefine.TREE, "tree");
            put(RunScheduleDetailListTableDefine.JOB_ID, "jobId");
            put(RunScheduleDetailListTableDefine.JOB_NAME, "jobName");
            put(RunScheduleDetailListTableDefine.JOB_TYPE, "jobType");
            put(RunScheduleDetailListTableDefine.CALENDAR_ID, "calendarId");
        }
    };

    public static final String getJobName(int id) {
        return JOB_COLUMN_NAME_MAP.get(id);
    }

    public static final String getHistoryName(int id) {
        return HISTORY_COLUMN_NAME_MAP.get(id);
    }

    public static final String getJobDetailName(int id) {
        return JOB_DETAIL_COLUMN_NAME_MAP.get(id);
    }

    public static final String getRunScheduleListName(int id) {
        return RUN_SCHEDULE_LIST_COLUMN_NAME_MAP.get(id);
    }

    public static final String getRunScheduleDetailListName(int id) {
        return RUN_SCHEDULE_DETAIL_LIST_COLUMN_NAME_MAP.get(id);
    }
}
