/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import com.clustercontrol.calendar.bean.ScheduleTableConstant;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebHeaderInvalidException;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetRunScheduleTableDefine;
import com.necsoft.hinemos.webclient.json.GridHeaderJson;
import com.necsoft.hinemos.webclient.util.ConvertListUtil;

/**
 * This class used for get header list
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetRunScheduleTableDefineBusiness {

    /**
     * Get header list
     * 
     * @param base
     *            : Date
     * @return ArrayList<TableColumnInfoJs>
     * @throws HinemosWebHeaderInvalidException
     */
    public ArrayList<TableColumnInfoJs> getRunScheduleTableDefine(Date base,
            Locale locale) throws HinemosWebException {
        // 中間変数を宣言
        ArrayList<TableColumnInfoJs> tblDefine = null;

        // Run Schedule table define を取得
        tblDefine = GetRunScheduleTableDefine.get(base, locale);

        // イベントテーブルヘッダー定義データの項目数チェック
        if (tblDefine.size() != (ScheduleTableConstant.DAYS + 1)) {
            // 項目数が不足の場合
            throw new HinemosWebHeaderInvalidException(
                    "exception.job.runschedule.number.header");
        }

        return tblDefine;
    }

    /**
     * Convert header to JSON structure
     * 
     * @param ArrayList
     *            <TableColumnInfoJs>
     * @return GridHeaderJson
     */
    public GridHeaderJson doConvertToJson(ArrayList<TableColumnInfoJs> tblDefine) {
        // Create JSON
        GridHeaderJson result = new GridHeaderJson();
        result.setColNames(ConvertListUtil.columnInfoToColNames(tblDefine));
        result.setColModel(ConvertListUtil.columnInfoToColModel(tblDefine));
        result.setRowNum(JobManagementConstants.ROW_NUM);

        return result;
    }
}
