/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.Collections;
import java.util.List;

import java.util.Locale;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.bean.HistoryTableDefine;
import com.clustercontrol.jobmanagement.bean.JobHistoryList;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.form.GridForm;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetHistory;
import com.necsoft.hinemos.webclient.jobmanagement.form.HistoryForm;
import com.necsoft.hinemos.webclient.jobmanagement.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

/**
 * This class used for get History Business list
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetHistoryBusiness {

    /**
     * Get History list
     * 
     * @param namingContext
     *            : NamingContext
     * @param form
     *            : HistoryForm
     * @return ArrayList<JobHistory>
     * @throws HinemosWebException
     */
    public List<List<Object>> getHistory(HistoryForm form, Property condition,
            NamingContext namingContext, Locale locale) throws HinemosWebException {

        GetHistory getHistory = new GetHistory();
        getHistory.setNamingContext(namingContext);
        JobHistoryList listInfoData = null;
        try {
            if (condition == null) {
                listInfoData = getHistoryData(namingContext);
            } else {
                listInfoData = getHistoryData(condition, namingContext);
            }
        } catch (HinemosWebRemoteException e) {
            throw new HinemosWebRemoteException(e);
        }

        List<List<Object>> list = ConvertListUtil
                .jobHistoryListToArrayList(listInfoData.getList(), locale);

        doSortListInfoData(form, list);

        ConvertListUtil.sanitizeHistoryList(list);

        return list;
    }

    private JobHistoryList getHistoryData(NamingContext namingContext)
            throws HinemosWebException {
        JobHistoryList listHistoryData = new JobHistoryList();
        // 履歴一覧を取得
        GetHistory getHistoryData = new GetHistory();
        getHistoryData.setNamingContext(namingContext);
        listHistoryData = getHistoryData
                .getHistory(JobManagementConstants.MAX_HISTORIES);
        return listHistoryData;
    }

    private JobHistoryList getHistoryData(Property condition,
            NamingContext namingContext) throws HinemosWebException {
        JobHistoryList listHistoryData = new JobHistoryList();
        // ステータス情報一覧データ(NodeInfoData)を取得
        // 履歴一覧を取得
        GetHistory getHistoryData = new GetHistory();
        getHistoryData.setNamingContext(namingContext);
        listHistoryData = getHistoryData.getHistory(condition,
                JobManagementConstants.MAX_HISTORIES);
        return listHistoryData;
    }

    /**
     * Sort data
     * 
     * @param form
     *            : GridForm
     * @param listInfoData
     *            : JobHistoryList
     * @return ArrayList<JobHistory>
     */
    private void doSortListInfoData(GridForm form, List<List<Object>> list) {

        // Get sorting parameter
        int sortColumnIndex = HistoryTableDefine.SORT_COLUMN_INDEX;
        int sortOrder = HistoryTableDefine.SORT_ORDER;
        if (form.getSidx() != null && !("").equals(form.getSidx().trim())) {
            sortColumnIndex = Integer.valueOf(form.getSidx());
        }
        if (form.getSord() != null && !("").equals(form.getSord().trim())) {
            sortOrder = SortOrderUtil.getSerInt(form.getSord());
        }

        // データをソート
        Collections.sort(list, new CommonTableViewerSorter(sortColumnIndex, -1,
                sortOrder));

    }

    /**
     * Convert data to JSON structure
     * 
     * @param listInfoData
     *            : ArrayList<JobHistory>
     * @return GridDataJson
     */
    public GridDataJson doConvertToJson(List<List<Object>> list) {
        // Create JSON
        GridDataJson result = new GridDataJson();

        // Set rows
        for (int countRow = 0; countRow < list.size();) {
            List<Object> arrData = list.get(countRow);
            result.addRow(arrData, String.valueOf(++countRow));
        }

        // Set other content
        result.setRecords(list.size());
        return result;
    }
}