/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.jobmanagement.bean.ScheduleTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[スケジュール]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得する
 * 
 */
public class GetScheduleTableDefine {

    /**
     * マネージャにSessionBean経由でアクセスし、<BR>
     * ジョブ[スケジュール]ビューのテーブル定義を取得する
     * 
     * @return テーブル定義情報 （{@link com.clustercontrol.bean.TableColumnInfoJs}のリスト）
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        // テーブル定義配列
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();
        // Locale locale = Locale.getDefault();

        tableDefine.add(ScheduleTableDefine.SCHE_ID, new TableColumnInfoJs(
                WebMessages.getString("schedule.id", locale),
                TableColumnInfoJs.NONE, 80, SWT.LEFT));
        tableDefine.add(ScheduleTableDefine.SCHE_NAME, new TableColumnInfoJs(
                WebMessages.getString("schedule.name", locale),
                TableColumnInfoJs.NONE, 150, SWT.LEFT));
        tableDefine.add(ScheduleTableDefine.JOB_ID, new TableColumnInfoJs(
                WebMessages.getString("job.id", locale),
                TableColumnInfoJs.NONE, 80, SWT.LEFT));
        tableDefine.add(ScheduleTableDefine.JOB_NAME, new TableColumnInfoJs(
                WebMessages.getString("job.name", locale),
                TableColumnInfoJs.NONE, 150, SWT.LEFT));
        tableDefine.add(ScheduleTableDefine.JOBUNIT_ID, new TableColumnInfoJs(
                WebMessages.getString("jobunit.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT));
        tableDefine.add(ScheduleTableDefine.CALENDAR_ID, new TableColumnInfoJs(
                WebMessages.getString("calendar.id", locale),
                TableColumnInfoJs.NONE, 80, SWT.LEFT));
        tableDefine.add(ScheduleTableDefine.SCHEDULE, new TableColumnInfoJs(
                WebMessages.getString("schedule", locale),
                TableColumnInfoJs.SCHEDULE, 100, SWT.LEFT));
        tableDefine.add(ScheduleTableDefine.VALID, new TableColumnInfoJs(
                WebMessages.getString("valid", locale) + "/"
                        + WebMessages.getString("invalid", locale),
                TableColumnInfoJs.VALID, 100, SWT.LEFT));
        tableDefine.add(ScheduleTableDefine.CREATE_USER, new TableColumnInfoJs(
                WebMessages.getString("creator.name", locale),
                TableColumnInfoJs.NONE, 80, SWT.LEFT));
        tableDefine.add(ScheduleTableDefine.CREATE_TIME, new TableColumnInfoJs(
                WebMessages.getString("create.time", locale),
                TableColumnInfoJs.NONE, 150, SWT.LEFT));
        tableDefine.add(ScheduleTableDefine.UPDATE_USER, new TableColumnInfoJs(
                WebMessages.getString("modifier.name", locale),
                TableColumnInfoJs.NONE, 80, SWT.LEFT));
        tableDefine.add(ScheduleTableDefine.UPDATE_TIME, new TableColumnInfoJs(
                WebMessages.getString("update.time", locale),
                TableColumnInfoJs.NONE, 150, SWT.LEFT));

        return tableDefine;

    }
}