/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.jobmanagement.bean.JobDetailTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[ジョブ詳細]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得する
 * 
 */
public class GetJobDetailTableDefine {

    /**
     * マネージャにSessionBean経由でアクセスし、<BR>
     * ジョブ[ジョブ詳細]ビューのテーブル定義を取得する
     * 
     * @return テーブル定義情報 （{@link com.clustercontrol.bean.TableColumnInfoJs}のリスト）
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        // テーブル定義配列
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();
        // Locale locale = Locale.getDefault();

        tableDefine.add(
                JobDetailTableDefine.TREE,
                new TableColumnInfoJs("", TableColumnInfoJs.NONE, 30, SWT.LEFT,
                        JobMappingUtil
                                .getJobDetailName(JobDetailTableDefine.TREE),
                        false));
        tableDefine.add(
                JobDetailTableDefine.STATUS,
                new TableColumnInfoJs(WebMessages.getString("run.status",
                        locale), TableColumnInfoJs.STATE, 80, SWT.LEFT,
                        JobMappingUtil
                                .getJobDetailName(JobDetailTableDefine.STATUS),
                        false));
        tableDefine
                .add(JobDetailTableDefine.END_STATUS,
                        new TableColumnInfoJs(
                                WebMessages.getString("end.status", locale),
                                TableColumnInfoJs.END_STATUS,
                                80,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getJobDetailName(JobDetailTableDefine.END_STATUS),
                                false));
        tableDefine
                .add(JobDetailTableDefine.END_VALUE,
                        new TableColumnInfoJs(
                                WebMessages.getString("end.value", locale),
                                TableColumnInfoJs.NONE,
                                50,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getJobDetailName(JobDetailTableDefine.END_VALUE),
                                false));
        tableDefine.add(
                JobDetailTableDefine.JOB_ID,
                new TableColumnInfoJs(WebMessages.getString("job.id", locale),
                        TableColumnInfoJs.NONE, 100, SWT.LEFT, JobMappingUtil
                                .getJobDetailName(JobDetailTableDefine.JOB_ID),
                        false));
        tableDefine
                .add(JobDetailTableDefine.JOB_NAME,
                        new TableColumnInfoJs(
                                WebMessages.getString("job.name", locale),
                                TableColumnInfoJs.NONE,
                                150,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getJobDetailName(JobDetailTableDefine.JOB_NAME),
                                false));
        tableDefine
                .add(JobDetailTableDefine.JOBUNIT_ID,
                        new TableColumnInfoJs(
                                WebMessages.getString("jobunit.id", locale),
                                TableColumnInfoJs.NONE,
                                100,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getJobDetailName(JobDetailTableDefine.JOBUNIT_ID),
                                false));
        tableDefine
                .add(JobDetailTableDefine.JOB_TYPE,
                        new TableColumnInfoJs(
                                WebMessages.getString("type", locale),
                                TableColumnInfoJs.JOB,
                                110,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getJobDetailName(JobDetailTableDefine.JOB_TYPE),
                                false));
        tableDefine
                .add(JobDetailTableDefine.FACILITY_ID,
                        new TableColumnInfoJs(
                                WebMessages.getString("facility.id", locale),
                                TableColumnInfoJs.NONE,
                                100,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getJobDetailName(JobDetailTableDefine.FACILITY_ID),
                                false));
        tableDefine.add(
                JobDetailTableDefine.SCOPE,
                new TableColumnInfoJs(WebMessages.getString("scope", locale),
                        TableColumnInfoJs.FACILITY, 150, SWT.LEFT,
                        JobMappingUtil
                                .getJobDetailName(JobDetailTableDefine.SCOPE),
                        false));
        tableDefine
                .add(JobDetailTableDefine.WAIT_RULE_TIME,
                        new TableColumnInfoJs(
                                WebMessages.getString("wait.rule.time", locale),
                                TableColumnInfoJs.NONE,
                                120,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getJobDetailName(JobDetailTableDefine.WAIT_RULE_TIME),
                                false));
        tableDefine
                .add(JobDetailTableDefine.START_RERUN_TIME,
                        new TableColumnInfoJs(
                                WebMessages.getString("start.rerun.time",
                                        locale),
                                TableColumnInfoJs.NONE,
                                150,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getJobDetailName(JobDetailTableDefine.START_RERUN_TIME),
                                false));
        tableDefine
                .add(JobDetailTableDefine.END_SUSPEND_TIME,
                        new TableColumnInfoJs(
                                WebMessages.getString("end.suspend.time",
                                        locale),
                                TableColumnInfoJs.NONE,
                                150,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getJobDetailName(JobDetailTableDefine.END_SUSPEND_TIME),
                                false));

        return tableDefine;
    }
}