/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.jobmanagement.bean.HistoryTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[履歴]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得する
 * 
 */
public class GetHistoryTableDefine {

    /**
     * マネージャにSessionBean経由でアクセスし、<BR>
     * ジョブ[履歴]ビューのテーブル定義を取得する
     * 
     * @return テーブル定義情報 （{@link com.clustercontrol.bean.TableColumnInfoJs}のリスト）
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        // テーブル定義配列
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();
        // Locale locale = Locale.getDefault();

        tableDefine.add(HistoryTableDefine.STATUS, new TableColumnInfoJs(
                WebMessages.getString("run.status", locale),
                TableColumnInfoJs.STATE, 80, SWT.LEFT, JobMappingUtil
                        .getHistoryName(HistoryTableDefine.STATUS)));
        tableDefine.add(HistoryTableDefine.END_STATUS, new TableColumnInfoJs(
                WebMessages.getString("end.status", locale),
                TableColumnInfoJs.END_STATUS, 80, SWT.LEFT, JobMappingUtil
                        .getHistoryName(HistoryTableDefine.END_STATUS)));
        tableDefine.add(HistoryTableDefine.END_VALUE, new TableColumnInfoJs(
                WebMessages.getString("end.value", locale),
                TableColumnInfoJs.NONE, 50, SWT.LEFT, JobMappingUtil
                        .getHistoryName(HistoryTableDefine.END_VALUE)));
        tableDefine.add(HistoryTableDefine.SESSION_ID, new TableColumnInfoJs(
                WebMessages.getString("session.id", locale),
                TableColumnInfoJs.NONE, 140, SWT.LEFT, JobMappingUtil
                        .getHistoryName(HistoryTableDefine.SESSION_ID)));
        tableDefine.add(HistoryTableDefine.JOB_ID, new TableColumnInfoJs(
                WebMessages.getString("job.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT, JobMappingUtil
                        .getHistoryName(HistoryTableDefine.JOB_ID)));
        tableDefine.add(HistoryTableDefine.JOB_NAME, new TableColumnInfoJs(
                WebMessages.getString("job.name", locale),
                TableColumnInfoJs.NONE, 150, SWT.LEFT, JobMappingUtil
                        .getHistoryName(HistoryTableDefine.JOB_NAME)));
        tableDefine.add(HistoryTableDefine.JOBUNIT_ID, new TableColumnInfoJs(
                WebMessages.getString("jobunit.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT, JobMappingUtil
                        .getHistoryName(HistoryTableDefine.JOBUNIT_ID)));
        tableDefine.add(HistoryTableDefine.JOB_TYPE, new TableColumnInfoJs(
                WebMessages.getString("type", locale), TableColumnInfoJs.JOB,
                110, SWT.LEFT, JobMappingUtil
                        .getHistoryName(HistoryTableDefine.JOB_TYPE)));
        tableDefine.add(HistoryTableDefine.FACILITY_ID, new TableColumnInfoJs(
                WebMessages.getString("facility.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT, JobMappingUtil
                        .getHistoryName(HistoryTableDefine.FACILITY_ID)));
        tableDefine.add(HistoryTableDefine.SCOPE, new TableColumnInfoJs(
                WebMessages.getString("scope", locale),
                TableColumnInfoJs.FACILITY, 150, SWT.LEFT, JobMappingUtil
                        .getHistoryName(HistoryTableDefine.SCOPE)));
        tableDefine
                .add(
                        HistoryTableDefine.SCHEDULED_START_TIME,
                        new TableColumnInfoJs(
                                WebMessages.getString("scheduled.start.time",
                                        locale),
                                TableColumnInfoJs.NONE,
                                150,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getHistoryName(HistoryTableDefine.SCHEDULED_START_TIME)));
        tableDefine
                .add(
                        HistoryTableDefine.START_RERUN_TIME,
                        new TableColumnInfoJs(
                                WebMessages.getString("start.rerun.time",
                                        locale),
                                TableColumnInfoJs.NONE,
                                150,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getHistoryName(HistoryTableDefine.START_RERUN_TIME)));
        tableDefine
                .add(
                        HistoryTableDefine.END_SUSPEND_TIME,
                        new TableColumnInfoJs(
                                WebMessages.getString("end.suspend.time",
                                        locale),
                                TableColumnInfoJs.NONE,
                                150,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getHistoryName(HistoryTableDefine.END_SUSPEND_TIME)));
        tableDefine.add(HistoryTableDefine.TRIGGER_TYPE, new TableColumnInfoJs(
                WebMessages.getString("trigger.type", locale),
                TableColumnInfoJs.NONE, 70, SWT.LEFT, JobMappingUtil
                        .getHistoryName(HistoryTableDefine.TRIGGER_TYPE)));
        tableDefine.add(HistoryTableDefine.TRIGGER_INFO, new TableColumnInfoJs(
                WebMessages.getString("trigger.info", locale),
                TableColumnInfoJs.NONE, 140, SWT.LEFT, JobMappingUtil
                        .getHistoryName(HistoryTableDefine.TRIGGER_INFO)));

        return tableDefine;
    }
}