/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.jobmanagement.bean.ForwardFileTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[ファイル転送]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得します。
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetForwardFileTableDefine {

    /**
     * マネージャにSessionBean経由でアクセスし、 ジョブ[ファイル転送]ビューのテーブル定義を取得します。<BR>
     * 
     * @return ジョブ[ファイル転送]ビューのテーブル定義情報
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        // テーブル情報定義配列
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();
        // Locale locale = Locale.getDefault();

        tableDefine.add(ForwardFileTableDefine.STATUS, new TableColumnInfoJs(
                WebMessages.getString("run.status", locale),
                TableColumnInfoJs.STATE, 80, SWT.LEFT));
        tableDefine.add(
                ForwardFileTableDefine.END_STATUS,
                new TableColumnInfoJs(WebMessages.getString("end.status",
                        locale), TableColumnInfoJs.END_STATUS, 80, SWT.LEFT));
        tableDefine.add(ForwardFileTableDefine.FILE_NAME,
                new TableColumnInfoJs(WebMessages.getString("file", locale),
                        TableColumnInfoJs.NONE, 150, SWT.LEFT));
        tableDefine.add(
                ForwardFileTableDefine.SRC_FACILITY_ID,
                new TableColumnInfoJs(WebMessages.getString("forward.source",
                        locale) + WebMessages.getString("facility.id", locale),
                        TableColumnInfoJs.NONE, 100, SWT.LEFT));
        tableDefine.add(
                ForwardFileTableDefine.SRC_FACILITY_NAME,
                new TableColumnInfoJs(WebMessages.getString("forward.source",
                        locale)
                        + WebMessages.getString("facility.name", locale),
                        TableColumnInfoJs.NONE, 100, SWT.LEFT));
        tableDefine.add(
                ForwardFileTableDefine.DEST_FACILITY_ID,
                new TableColumnInfoJs(WebMessages.getString(
                        "forward.destination", locale)
                        + WebMessages.getString("facility.id", locale),
                        TableColumnInfoJs.NONE, 100, SWT.LEFT));
        tableDefine.add(
                ForwardFileTableDefine.DEST_FACILITY_NAME,
                new TableColumnInfoJs(WebMessages.getString(
                        "forward.destination", locale)
                        + WebMessages.getString("facility.name", locale),
                        TableColumnInfoJs.NONE, 100, SWT.LEFT));
        tableDefine.add(
                ForwardFileTableDefine.START_RERUN_TIME,
                new TableColumnInfoJs(WebMessages.getString("start.rerun.time",
                        locale), TableColumnInfoJs.NONE, 150, SWT.LEFT));
        tableDefine.add(
                ForwardFileTableDefine.END_SUSPEND_TIME,
                new TableColumnInfoJs(WebMessages.getString("end.suspend.time",
                        locale), TableColumnInfoJs.NONE, 150, SWT.LEFT));

        return tableDefine;
    }
}