/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.bean;

import java.util.Map;

import com.clustercontrol.bean.TableColumnInfo;

public class TableColumnInfoJs extends TableColumnInfo {

    private static final long serialVersionUID = -3251648441057998749L;

    private String index;

    private String classes;

    private boolean editable;

    private String modelName;

    private boolean sortable;

    private boolean key;

    private String formatter;

    private Map<String, Object> formatoptions;

    private String sorttype;

    public TableColumnInfoJs(String name, int type, int width, int style) {
        super(name, type, width, style);

        this.sortable = true;
        this.key = false;
    }

    public TableColumnInfoJs(String name, int type, int width, int style,
            String modelName) {
        super(name, type, width, style);

        this.sortable = true;
        this.key = false;
        setModelName(modelName);
    }

    public TableColumnInfoJs(String name, int type, int width, int style,
            boolean sortable) {
        super(name, type, width, style);

        this.key = false;
        this.sortable = sortable;
    }

    public TableColumnInfoJs(String name, int type, int width, int style,
            String modelName, boolean sortable) {
        super(name, type, width, style);

        this.sortable = sortable;
        this.key = false;
        setModelName(modelName);
    }

    public String getClasses() {
        return classes;
    }

    public void setClasses(String classes) {
        this.classes = classes;
    }

    public String getIndex() {
        return index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public Boolean getEditable() {
        return editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public boolean isSortable() {
        return sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isKey() {
        return key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public String getFormatter() {
        return formatter;
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public Map<String, Object> getFormatoptions() {
        return formatoptions;
    }

    public void setFormatoptions(Map<String, Object> formatoptions) {
        this.formatoptions = formatoptions;
    }

    public String getSorttype() {
        return sorttype;
    }

    public void setSorttype(String sorttype) {
        this.sorttype = sorttype;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

}
