/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create monitor scope
 */
var fn = function(_view){
	var __ = cm;
	
	 var view = $.extend({}, __._fnview_tree_grid, {
		load_flg    : false
		,facility_id: ""
		,/*
		 * Set caption of grid
		 */
		setCaption: function(path){
			this.grid.setCaption([__.getLang("scope"), ": " , path].join(""));
		}
		
		,/*
		 * On click a node of tree
		 */
		onclickTree: function(node_data){
			var _ = this
			;
			_.facility_id = node_data.facilityId;
			_.setCaption(node_data.path);
			
			if (!(_.load_flg)) {
				_.load_flg = true;
				_.reloadGrid();
			}
		}
		,/*
		 * reload Grid
		 */
		reloadGrid: function(){
			var _ = this
			;
			
			_.grid.refreshData({
				facilityId: _.facility_id
			});
		}
		
		,/*
		 * Get scope list
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_scope_list_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					// Cache local variants
					var grid = _.grid
					,pager   = grid.$pgr
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Set some options for grid
					$.extend(data_respond,{
						url          : "get_scope_list"
						,pager       : pager
						,caption     : [__.getLang("scope"), ": "].join("")
						,sortable    : true
						,viewrecords : true
						,loadComplete: function(){
							var post_data = grid.getGridParam("postData")
							,facility_id
							;
							if((facility_id = post_data.facilityId) === undefined){
								facility_id = "";
							}
							if(facility_id === _.facility_id){
								_.load_flg = false;
							}else{
								setTimeout(function(){
									_.reloadGrid();
								}, 1);
							}
							// Set refresh data
							_view.setRefresh();
							
							// Set priority bar
							_.setPriorityStatusBar();
						}
					});
				
					grid.processData(data_respond);
					grid.controlSize();
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Get facility tree
		 */
		getTree: function(){
			return __.fclt_tree.get(this._id);
		}
		
		,/*
		 * Reset data of panes of views
		 */
		resetView: function(tree){
			var _ = this;
			
			_.tree.refreshData(tree);
			
			_.grid.refreshData({
				facilityId: ""
			});
			
			_.setCaption("");
		}
		
		,/*
		 * Refresh data
		 */
		refreshData: function(){
			this.grid.refreshData();
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _     = this;
			var _btns = _.$btns;
			
			// Bind actions for button in left of pane
			// Bind update grid data
			_btns.children("#update").click(function(){
				_.grid.refreshData();
			});
			// Bind toggle left pane
			_btns.children("#toggle_view").click(function(){
				_.togglePane("west", this);
			});
		}
	});
	
	return view;
};