/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Declare function of views
 */
cm._fnview = {
	/********************************************************
	 * Ids for DOMs
	 */
	/*
	 * Get id (form) of from element
	 */
	ele2Id: function(p_ele){
		return [p_ele, "_", this._id].join("");
	}
		
	,/*
	 * Get container id (form) 
	 */
	getCtnId: function(p_nm){
		return [p_nm, "_ctn_", this._id].join("");
	}
	
	,/********************************************************
	 * Control view properties
	 */
	/*
	 * Action for button which handle toggle a view o layout
	 */
	togglePane: function(direction, button){
		// Control
		var _ = this
		;
		_.$layout.data("layout").toggle(direction);
		$(button).toggleClass("ui-button-active");
	}
	
	,/*
	 * Resize elements of view
	 */
	resizeInner: function(){
		var _  = this
		,comps = _._comps
		,comp
		;
		
		for(var l_len = comps.length; l_len--;){
			comp = comps[l_len];
			if(_[comp] && _[comp].controlSize){
				_[comp].controlSize();
			}}
	}
	
	,/*
	 * Cache DOM data frequently use, abstract
	 */
	cacheDom: function(){
		var _   = this
		,doms   = {}
		,comps  = _.setComp()
		,_comps = []
		,len
		;
		
		if(!(comps && $.isArray(comps) && (len = comps.length))){
			return false;
		}
		
		while(len--){
			var comp = comps[len];
			
			// Check validation of component
			if(!($.isArray(comp) && (comp.length == 2))){
				return false;
			}
			
			// Push value 'name' to component
			var name = comp[0];
			_comps.push(name);
			
			// Cache DOM
			var dom = doms[name] = _[comp[1]](name);
			
			// Add id for container
			dom.$ctn.attr("id", _.getCtnId(name));
			dom.attr("id", _.ele2Id(name));
		}
		
		// Add extend doms and comps for view
		$.extend(_, doms, {_comps: _comps});
		
		return true;
	}
	
	,/********************************************************
	 * Cache function
	 */
	/*
	 * Tree form
	 */
	cacheTree: function(p_name){
		var _ = this
		,_ctn = _.$ctn
		,tree
		,ctn
		;
		
		// Get component
		tree = _ctn.find(["#", p_name].join(""));
		ctn  = tree.parent();
		
		// Cache container and control size
		$.extend(tree, {
			$ctn        : ctn
			,controlSize: function(){
				var i = this
				,ctn  = i.$ctn
				;
				
				i.width(ctn.width());
				i.height(ctn.height());
			}
			,processData: function(p_opts, tree_data){
				var i      = this
				,options   = $.extend(
					{}
					,{
						clickFolderMode: 1
						,children      : tree_data
					}
					,p_opts
				)
				;
				
				i.dynatree(options)
			}
			,refreshData: function(tree_data){
				// Declare local variant
				var i = this
				,tree = i.dynatree("getTree")
				;
				
				// Renew tree
				tree.options.children = [tree_data];
				tree.reload();
			}
		});
		
		return tree;
	}
		
	,/*
	 * Grid form
	 */
	cacheGrid: function(p_name){
		var _ = this
		,_ctn = _.$ctn
		,grid
		,ctn
		,pager_name = [p_name, "_pager"].join("")
		,pager
		;
		
		// Get component
		grid  = _ctn.find(["#", p_name].join(""));
		ctn   = grid.parent();
		pager = ctn.children(["#", pager_name].join(""));
		
		// Check pager
		if(pager.length !== 0){
			// Set pager
			pager.attr("id", _.ele2Id(pager_name));
			grid.$pgr = pager;
		}
		
		// Cache container
		$.extend(grid, {
			$ctn        : ctn
			,controlSize: function(){
				var i = this
				,ctn  = i.$ctn
				,w    = ctn.width()
				,pg_h = 0
				;
				// Get height of pager
				if(i.$pgr){
					pg_h = i.$pgr.outerHeight(true);
				}
				
				// Calculate values of height and with
				var h = ctn.height() -
						(
							$("thead:first tr.ui-jqgrid-labels"
									,i[0].grid.hDiv).outerHeight(true) // Header
							+$(["#gview_", i[0].id  ," > div.ui-jqgrid-titlebar"].join("")
									,ctn).outerHeight(true) + // Caption
							pg_h
						);
				
				// Check height
				if(h < 1){
					h = 1;
				}
				
				// Set size of grid
				i.setGridWidth(w, false);
				i.setGridHeight(h, false);
			}
			,processData: function(p_opts){
				// Get load complete
				var i         = this
				,loadComplete = false
				;
				
				// Get declare for load complete
				if(p_opts.loadComplete){
					loadComplete = p_opts.loadComplete;
					
					// Delete properties were used
					delete p_opts.loadComplete;
				}
				
				var options = $.extend(
					{}
					,{
						datatype    : "json"
						,hidegrid    : false
						,shrinkToFit : false
						,pgbuttons   : false
						,pgtext      : ""
						,mtype       : "POST"
						,loadComplete: function(data_respond){
							// Check validation of data_respond
							var check_value;
							if(i.getGridParam("datatype") == "json"){
								if ((check_value = cm.checkJsonError(data_respond))
									=== false){
									return;
								}
								
								// Prevent for load grid
								if(check_value !== true){
									i._stop = true;
								}
								
								}
							
							// Set load complete
							if(loadComplete){
								loadComplete(i);
							}
						}
						,loadError   : cm.loadDataError
					},        // default
					p_opts // options
				);
				
				i.jqGrid(options);
				
				// Bind action hide contextMenu, when click grid and it's header
				i.click(cm.hideDefaultNoneDisplay);
				$("thead:first tr.ui-jqgrid-labels > th > div",
						grid[0].grid.hDiv).click(cm.hideDefaultNoneDisplay);
			}
			,refreshData: function(post_data){
				var i = this
				;
				
				// Check weather prevent load grid
				if(i._stop){
					return;
				}
				
				if(post_data){
					i.jqGrid("setGridParam", {postData: post_data});
				}
				
				i.trigger("reloadGrid");
			}
		});
		
		return grid;
	}
	
	/********************************************************
	 *
	 * Main actions
	 */
	,/*
	 * Initialize
	 */
	init: function(){
		// Cache local variant
		var _ = this;
		
		// Cache DOM (processed in fnComponent.js)
		_.cacheDom();
		
		// Create scope layout (processed in fnViewLayout.js)
		_.createLayout();
		
		// Load data (processed in fnViewLayout.js)
		_.loadData();
		
		// Create dialogs (processed in private files)
		if(_.createDialog){
			_.createDialog()
		}
		
		// Bind some action (processed in private file)
		_.bindAction();
	}
};
