/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Declare common functions: function which view has action.
 */
(function(__){
	
	var declareGridDialog = function(dlg_nm, d_inform, bd_opt){
		var _  = this
		,bd_id = _.ele2Id(dlg_nm)
		,title
		;
		
		// Get form of title
		if(title = d_inform.option.title){
			d_inform.option.title = __.getIconStrTitle(title);
		}
		
		return {
			_tplt: [
				"<div id='"
				,_.getCtnId(dlg_nm)
				,"' class='dlg-container'><table id='"
				,bd_id
				,"'></table></div>"
			].join("")
			
			,// Option of this dialog
			_opt: d_inform.option
			
			,// Body id
			_bd_id: bd_id
			
			,// Body dialog options
			_bd_opt: bd_opt
				
			,// Process open this dialog
			open: function(){
				var i = this // dialog
				,$dlg
				,$bd // body dialog
				;
				
				// Show warning message
				if((i._bd_opt.prm_msg !== undefined) 
						&& (i._bd_opt.prm_msg !== null)){
					
					// Show warning dialog
					__.openPromptDlg(i._bd_opt.prm_msg);
					return;
				}
				
				// Default option
				var dft_opts = {
					closeOnEscape: false
					,resizable   : true
					,modal       : true
					,autoOpen    : true
					,resize      : function(){
						i.controlSize();
					}
					,close       : function(){
						// Remove dialog
						$(this).dialog("destroy");
						$dlg.remove();
						delete i.$dlg;
					}
				}
				;
				
				/*
				 * Dialog
				 */
				// Declare template
				$dlg = $(i._tplt);
				
				// Add to control
				i.$dlg = $dlg;
				
				// Append $_dlg to body
				$dlg.appendTo("body");
				
				// Create dialog
				$dlg.dialog($.extend(dft_opts, i._opt));
				
				/*
				 * Body of dialog
				 */
				// Declare body
				$bd = $dlg.children(["#", i._bd_id].join(""));
				
				// Declare component dialog
				$dlg.$bd = $bd;
				
				// Get grid data
				$bd.jqGrid(i._bd_opt);
			}
			
			,/*
			 * This function is only active after dialog is opened.
			 */
			controlSize: function(){
				var $dlg = this.$dlg
				,$bd     = $dlg.$bd
				,w       = $dlg.width()
				;
				
				// Calculate values of height and with
				var h = $dlg.height() -
						(
							$("thead:first tr.ui-jqgrid-labels"
									,$bd[0].grid.hDiv).outerHeight(true) // Header
							+$("#gview_" + $bd[0].id + " > div.ui-jqgrid-titlebar"
									,$dlg).outerHeight(true) // Caption
						);
				
				// Check height
				if(h < 1){
					h = 1;
				}
				
				// Set size of grid
				$bd.setGridWidth(w, false);
				$bd.setGridHeight(h, false);
			}
		}
	}
	
	$.extend(__, {
		/************************************************************
		 * Create dialog which has property form and perform a function
		 */
		crePropActnDlg: function(dlg_nm, d_inform, loadComplete){
			var _   = this
			,__     = cm
			,dlg    = {} // Declare dialog
			,bd_opt = {
				treeGridModel: "adjacency"
				,datatype    : "jsonstring"
				,hidegrid    : false
				,shrinkToFit : false
				,treeGrid    : true
				,treedatatype: "local"
				,ExpandColumn: "name"
				,treeIcons   : {
					plus  : "ui-icon-hnm-plus"
					,minus: "ui-icon-hnm-minus"
					,leaf : "ui-icon-hnm-none"
				}
				,colNames    : ["id", __.getLang("name"), __.getLang("value")]
				,colModel    : [
					{index : "0", name: "id", width: 15, key: true, hidden: true}
					,{index: "1", name: "name", width: 180, align: "left"
						,classes: "dlg-name-property", sortable: false}
					,{index: "2", name: "value", width: 180, align: "left"
						,sortable: false, classes: "grid-cell-input"}
				]
				,jsonReader  : {
					repeatitems: false,
					root       : function (obj) { return obj; },
					page       : function (obj) { return 1; },
					total      : function (obj) { return 1; },
					records    : function (obj) { return obj.length; }
				}
				,caption     : __.getLang("attribute")
				,loadComplete: function(){
					dlg.bindInput();
					dlg.controlSize();
					if(loadComplete && ((typeof loadComplete) == "function" )){
						loadComplete();
					}
				}
			}
			;
			
			// Get (local) data
			$.ajax({
				url      : d_inform.url
				,dataType: "json"
				,cache   : false
				,success : function(data_respond){
					// Check validation of data_respond
					var check_value;
					if((check_value = __.checkJsonError(data_respond, false))
							=== false){
						return;
					}
					
					// Check waring
					if(check_value === true){
						// Set content for body
						bd_opt.datastr = data_respond.data;
					}else{
						// Set error message
						bd_opt.prm_msg = check_value;
					}
				}
				,error   : __.loadDataError
			});
			
			// Add method to process this function
			$.extend(dlg, declareGridDialog.call(_, dlg_nm, d_inform, bd_opt), {
				/*
				 * Get parameter from filter form and make request
				 */
				execute: function(callback){
					var i   = this
					,values = {}
					,pars   = i.$dlg.$bd.find(":input")
					,len    = pars.length
					;
					
					// Store values
					while(len--){
						var par = pars[len];
						values[par.id] = par.value;
					}
					
					// Call back function
					callback.call(_, values);
					
					// Store value
					i._values = values
				}
				
				,/*
				 * Store date fields
				 */
				bindInput: function(){
					var i   = this
					,ftr_bd = i.$dlg.$bd
					// Except button for proper to 
					,fields = ftr_bd.find(":input:not(button)")
					,in_dft = {}
					,len    = fields.length
					,values
					,value
					;
					
					// If set values
					if(values = i._values){
						var cnt = len
						;
						
						// Set input values
						 while(cnt--){
							var field = $(fields[cnt])
							,field_id = field.attr("id")
							;
							
							// Set input value
							 if((value = values[field_id]) !== undefined){
								 field.val(value);
							 }
						 }
					}else{
						// Store default
						 var cnt = len
						 ,in_dft = {}
						 ;
						 
						 // Store input default
						// Set value
						 while(cnt--){
							 var field = $(fields[cnt])
							 ,field_id = field.attr("id")
							 ;
							 
							 // Store default value for reseting values
							in_dft[field_id] = field.val();
						 }
						 
						// Store for reset action
						i._in_dft = in_dft;
					}
					
					fields.each(function(index, ele){
						var field = $(fields[index]);
						
						// Set selection for the row which contains this input
						// This make row become active
						field.click(function(){
							ftr_bd.jqGrid("setSelection", ele.id);
						});
						
						// Set date time picker
						if(field.hasClass("input-datetime")){
							field.datetimepicker(cm.getLang("datetimepicker"));
							field.click(function(){
								$(this).next()
									.css("visibility", "visible")
								;
							});
						}
						
					});
					
					// Bind action when click a row
					ftr_bd.jqGrid("setGridParam", {
						onSelectRow : function(row_id){
							var $_ = $(this);
							
							// Hide the image of date time picker
							$_.find("td > img.ui-datetimepicker-trigger")
								.css("visibility", "hidden")
							;
							
							// Hide buttons
							$_.find("tr:not(:.ui-state-highlight) button")
								.css("visibility", "hidden")
							;
						}
					});
				}
				
				,/*
				 * Reset input field
				 */
				reset: function(){
					var i   = this
					,ftr_bd = i.$dlg.$bd
					,fields = ftr_bd.find(":input")
					,field
					,in_dft = i._in_dft
					,value
					;
					
					// Set default value
					fields.each(function(index, ele){
						field = $(fields[index]);
						if((value = in_dft[ele.id]) !== undefined){
							field.val(value);
						}
					});
					
					// Collapse all tree
					ftr_bd.find(".treeclick").each(function() {
						if($(this).hasClass("tree-minus")){
							$(this).trigger("click");
						}
					});
					
					// Set hidden button and image
					ftr_bd
						.find("td > img.ui-datetimepicker-trigger")
							.css("visibility", "hidden")
							.end()
					;
				}
				
				,/*
				 * Set data for inputs
				 */
				setInput: function(values){
					this._values = values;
				}
			});
			
			/*
			 *  Declare completely
			 */
			_[dlg_nm] = dlg;
		}
		
		,/***********************************************************
		 * Action: get detail of a record 
		 */
		crePropInfoDlg: function(dlg_nm, d_inform){
			var _   = this
			,__     = cm
			,dlg    = {} // Declare dialog
			,bd_id  = _.ele2Id(dlg_nm)
			,bd_opt = {
				datatype     : "json"
				,url         : d_inform.url
				,height      : 1
				,hidegrid    : false
				,mtype       : "POST"
				,shrinkToFit : false
				,colNames    : [__.getLang("name"), __.getLang("value")]
				,colModel    : [
					{index : "0", name: "name", width: 180, align: "left"
						,classes: "dlg-name-property", sortable: false}
					,{index: "1", name: "value", width: 180, align: "left"
						,formatter: "hnmPropertyView", sortable: false}
				]
				,caption     : __.getLang("attribute")
			}
			;
			
			// Header is not declared or equals 0
			$.extend(bd_opt, d_inform.body);
			
			/*
			 * Requires
			 */
			// Get function required for this action
			$.extend(dlg, declareGridDialog.call(_, dlg_nm, d_inform, bd_opt), {
				/*
				 * Set post data for getting grid data
				 */
				setPostData: function(post_data){
					this._bd_opt.postData = post_data;
				}
			});
			
			/*
			 *  Declare completely
			 */
			_[dlg_nm] = dlg;
		}
	});
})(cm);