/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * On Ready
 */
$(document).ready(function(){
	/**************************************************************************
	 * Functions is used for processing login
	 */
	var loginAction = function(){
		var err_msg = {
			user_null : "${message.accesscontrol.1}"
			,pass_null: "${message.accesscontrol.2}"
			,url_null : "${message.hinemos.9}"
		}
		,user_name  = $(":input[name=userName]")
		,password   = $(":input[name=password]")
		,url_server = $(":input[name=urlServer]")
		,ntf_error  = $("#ntfErrMessage")
		;
		
		// Check whether user name is null
		if($.trim(user_name.val()) == ""){
			ntf_error.html(err_msg.user_null);
			return;
		}
		
		// Check whether password is null
		if(password.val() == ""){
			ntf_error.html(err_msg.pass_null)
			return;
		}
		
		// Check whether url server is null
		if($.trim(url_server.val()) == ""){
			ntf_error.html(err_msg.url_null);
			return;
		}
		
		$("form:first").submit();
		
		return;
	}
	
	/*
	 * Clear parameters of input;
	 */
	var clearParameter = function(){
		// Clear inputs and error message
		$(":input:not(button)").val("");
		$("#ntfErrMessage").text("");
	}
	
	// Bind action
	$("#btn_login").click(loginAction);
	$("#btn_clear").click(clearParameter);
	
	// Bind action submit when press enter key
	$("#frm-login").keypress(function(e){
		var code= (e.keyCode ? e.keyCode : e.which);
		if(code == 13){
			loginAction();
		}
	})
	
	/**************************************************************************
	 * Process layout
	 */
	$("body").layout({
		north__spacing_open : 0
		,south__spacing_open: 0
		,north__size        : 0.15
		,south__size        : 0.07
		,enableCursorHotkey : false
		,showErrorMessages  : false
	});
});