/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.util;

import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.repository.bean.NodeFilterConstant;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.util.PropertyUtil;

/**
 * ノードフィルタ用プロパティを作成するクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeFilterProperty {

    private static Log m_log = LogFactory.getLog(NodeFilterProperty.class);

    /** ----- 初期値キャッシュ ----- */
    private static HashMap<Locale, Property> cachedInitProperty = null;

    static {
        cachedInitProperty = new HashMap<Locale, Property>();
    }

    /**
     * ノードフィルタ用プロパティを返します。
     * 
     * @param locale
     * @return ノードフィルタ用プロパティ
     */
    public static Property getProperty(Locale locale) {

        // 初期値のキャッシュが存在すれば、それを返す
        if (cachedInitProperty.containsKey(locale)) {
            m_log.debug("using a initial property of node's filter to cache. (locale = "
                    + locale + ")");
            return PropertyUtil.copy(cachedInitProperty.get(locale));
        }

        // ファシリティID
        Property facilityId = new Property(NodeFilterConstant.FACILITY_ID,
                WebMessages.getString("facility.id", locale),
                PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
        // ファシリティ名
        Property facilityName = new Property(NodeFilterConstant.FACILITY_NAME,
                WebMessages.getString("facility.name", locale),
                PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
        // 説明
        Property description = new Property(NodeFilterConstant.DESCRIPTION,
                WebMessages.getString("description", locale),
                PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
        // IPアドレス v4
        Property ipAddressV4 = new Property(NodeFilterConstant.IP_ADDRESS_V4,
                WebMessages.getString("ip.address.v4", locale),
                PropertyConstant.EDITOR_IPV4);
        // IPアドレス v6
        Property ipAddressV6 = new Property(NodeFilterConstant.IP_ADDRESS_V6,
                WebMessages.getString("ip.address.v6", locale),
                PropertyConstant.EDITOR_IPV6);
        // OS名
        Property osName = new Property(NodeFilterConstant.OS_NAME,
                WebMessages.getString("os.name", locale),
                PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
        // OSリリース
        Property osRelease = new Property(NodeFilterConstant.OS_RELEASE,
                WebMessages.getString("os.release", locale),
                PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
        // 管理者
        Property administrator = new Property(NodeFilterConstant.ADMINISTRATOR,
                WebMessages.getString("administrator", locale),
                PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
        // 連絡先
        Property contact = new Property(NodeFilterConstant.CONTACT,
                WebMessages.getString("contact", locale),
                PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);

        // ネットワーク
        Property network = new Property(NodeFilterConstant.NETWORK,
                WebMessages.getString("network", locale),
                PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
        // OS
        Property os = new Property(NodeFilterConstant.OS,
                WebMessages.getString("os", locale),
                PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
        // 保守
        Property maintenance = new Property(NodeFilterConstant.MAINTENANCE,
                WebMessages.getString("maintenance", locale),
                PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);

        // 値を初期化
        facilityId.setValue("");
        facilityName.setValue("");
        description.setValue("");
        ipAddressV4.setValue("");
        ipAddressV6.setValue("");
        osName.setValue("");
        osRelease.setValue("");
        administrator.setValue("");
        contact.setValue("");

        os.setValue("");
        network.setValue("");
        maintenance.setValue("");

        // 変更の可/不可を設定
        facilityId.setModify(PropertyConstant.MODIFY_OK);
        facilityName.setModify(PropertyConstant.MODIFY_OK);
        description.setModify(PropertyConstant.MODIFY_OK);
        ipAddressV4.setModify(PropertyConstant.MODIFY_OK);
        ipAddressV6.setModify(PropertyConstant.MODIFY_OK);
        osName.setModify(PropertyConstant.MODIFY_OK);
        osRelease.setModify(PropertyConstant.MODIFY_OK);
        administrator.setModify(PropertyConstant.MODIFY_OK);
        contact.setModify(PropertyConstant.MODIFY_OK);

        os.setModify(PropertyConstant.MODIFY_NG);
        network.setModify(PropertyConstant.MODIFY_NG);
        maintenance.setModify(PropertyConstant.MODIFY_NG);

        Property property = new Property(null, null, "");

        // 初期表示ツリーを構成。
        property.removeChildren();
        property.addChildren(facilityId);
        property.addChildren(facilityName);
        property.addChildren(description);
        property.addChildren(network);
        property.addChildren(os);
        property.addChildren(maintenance);

        // ネットワークツリー
        network.removeChildren();
        network.addChildren(ipAddressV4);
        network.addChildren(ipAddressV6);

        // OSツリー
        os.removeChildren();
        os.addChildren(osName);
        os.addChildren(osRelease);

        // 保守ツリー
        maintenance.removeChildren();
        maintenance.addChildren(administrator);
        maintenance.addChildren(contact);

        // 初期値をキャッシュに登録（次回から高速化に初期値を取得）
        m_log.info("adding a initial property of user's filter to cache. (locale = "
                + locale + ")");
        cachedInitProperty.put(locale, PropertyUtil.copy(property));

        return property;
    }
}
