/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.Constants;
import com.necsoft.hinemos.webclient.common.CssClass;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.repository.action.GetNodeScopeTableDefine;
import com.necsoft.hinemos.webclient.repository.business.GetNodeScopeTableDefineBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * This class used for display header of NodeScope view
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetNodeScopeTableDefineServlet extends CommonServlet {

    private static final long serialVersionUID = -3549808862378505598L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetNodeScopeTableDefineServlet.class);

    public CommonJson process(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

        // 中間変数を宣言
        CommonJson result = new CommonJson();
        GetNodeScopeTableDefineBusiness business = null;
        try {
            business = new GetNodeScopeTableDefineBusiness();
            
            //get data
            ArrayList<TableColumnInfoJs> tblDefine = business.getNodeScopeTableDefine(request.getLocale());
            
            //Set first position
            tblDefine.get(0).setClasses(CssClass.GRID_FIRST_COLUMN);
            
            //convert to json
            result = DataProcess.doConvertTableDefineToJson(
                    tblDefine, false, request.getLocale(),
                    Constants.MAX_TABLE_ROW_NUM,
                    GetNodeScopeTableDefine.SORT_COLUMN_INDEX,
                    GetNodeScopeTableDefine.SORT_ORDER);
            
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }
}