/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.Constants;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.repository.business.GetNodeFilterPropertyBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * ノード情報データをリフレッシュするクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetNodeFilterPropertyServlet extends CommonServlet {
    private static final long serialVersionUID = -3131350422822624183L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetNodeFilterPropertyServlet.class);

    public CommonJson process(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

        CommonJson result = new CommonJson();

        try {
            //get data
            Property propertyNode = getNodeFilterProperty(request);
            
            //convert to json
            result = DataProcess.doConvertFilterToJson(propertyNode);
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }

    private Property getNodeFilterProperty(HttpServletRequest request)
            throws HinemosWebException {
        // 中間変数を宣言
        Property propertyNode = null;
        HttpSession session = request.getSession(true);
        GetNodeFilterPropertyBusiness business = null;
        if (session.getAttribute(Constants.NODE_FILTER_PROPERTIES) == null) {
            business = new GetNodeFilterPropertyBusiness();
            propertyNode = business.getNodeFilterProperty(request.getLocale());
            session.setAttribute(Constants.NODE_FILTER_PROPERTIES, propertyNode);
        } else {
            propertyNode = (Property) session
                    .getAttribute(Constants.NODE_FILTER_PROPERTIES);
        }
        return propertyNode;
    }
}