/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.business;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.nodemap.bean.ReservedFacilityIdConstant;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import com.necsoft.hinemos.webclient.action.FacilityTree;
import com.necsoft.hinemos.webclient.bean.FacilityConstant;
import com.necsoft.hinemos.webclient.bean.FacilityPath;
import com.necsoft.hinemos.webclient.common.CssClass;
import com.necsoft.hinemos.webclient.composite.FacilityTreeViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.repository.bean.FacilityTreeBean;
import com.necsoft.hinemos.webclient.repository.json.FacilityTreeJson;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * This class used to display Facility List Business
 * 
 * @version 1.0
 * @since 1.0.0
 */
public class GetFacilityListBusiness {

    /**
     * Get detail of Facility scope list
     * @return result JSON
     */
    public FacilityTreeJson getFacilityTree(EndpointManager endpointManager)
        throws HinemosWebException {
        FacilityTreeJson fclTreeJs = new FacilityTreeJson();
        Map<String, Integer> typeList = new HashMap<String, Integer>();

        // FacilityTree を取得
        FacilityTree facilityTree = new FacilityTree();

        // セパレータを取得
        FacilityPath path = new FacilityPath(facilityTree.getSeparator());

        // ファシリティ一覧を取得
        FacilityTreeItem treeItemRoot = facilityTree.getTreeItem(endpointManager);

        if (treeItemRoot == null) {
         // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        }

        // Create data JSON
        List<FacilityTreeItem> treeItems = treeItemRoot.getChildren();

        for (int cnt = 0; cnt < treeItems.size(); cnt++) {
            fclTreeJs.addFacilityTree(treeItem2TreeBean(treeItems.get(cnt), path,
                    new StringBuffer(""), typeList));
        }

        fclTreeJs.setTypeList(typeList);
        fclTreeJs.setReservedList(getReservedList());

        return fclTreeJs;
    }

    /**
     * Convert FacilityTreeItem to FacilityTreeBean
     * 
     * @param treeItem
     * @param path
     * @param key
     * @return
     */
    private FacilityTreeBean treeItem2TreeBean(FacilityTreeItem treeItem,
            FacilityPath path, StringBuffer key, Map<String, Integer> typeList) {
        FacilityTreeBean treeBean = new FacilityTreeBean();
        FacilityInfo facilityInfo = treeItem.getData();
        StringBuffer title = new StringBuffer(facilityInfo.getFacilityName());
        String facilityId = facilityInfo.getFacilityId();
        int type = facilityInfo.getFacilityType();

        if (type != FacilityConstant.TYPE_COMPOSITE) {
            // Append title
            title.append(" (");
            title.append(facilityId);
            title.append(")");

            // Append key
            key.append(path.getSeparator());
            key.append(facilityId);

            typeList.put(StringEscapeUtils.escapeHtml3(facilityId), type);
        }

        // Set component of FacilityTreeBean
        treeBean.setTitle(StringEscapeUtils.escapeHtml3(title.toString()));
        treeBean.setTooltip(StringEscapeUtils.escapeHtml3(title.toString()));
        treeBean.setFacilityId(StringEscapeUtils.escapeHtml3(facilityId));
        treeBean.setPath(StringEscapeUtils.escapeHtml3(path.getPath(treeItem)));
        treeBean.setKey(key.toString());

        // Set children of node
        if (type == FacilityConstant.TYPE_NODE) {
            // Not contain children, check valid of node
            if (!facilityInfo.isValid()) {
                treeBean.setAddClass(CssClass.TREE_NODE_INVALID);
                treeBean.setValid(false);
            }
        } else {
            // Set class for FacilityTreeBean
            treeBean.setIsFolder(true);
            if (type == FacilityConstant.TYPE_COMPOSITE) {
                treeBean.setAddClass(CssClass.TREE_SCOPE_ROOT);
            }

            // Set children for this FacilityTreeBean
            // データをソート
            List<FacilityTreeItem> treeItemChildren = treeItem.getChildren();
            Collections.sort(treeItemChildren, new FacilityTreeViewerSorter());

            // 子ノードリストを取得
            for (int cnt = 0; cnt < treeItemChildren.size(); cnt++) {
                treeBean.addChildren(treeItem2TreeBean(
                        treeItemChildren.get(cnt), path, key, typeList));
            }
        }

        return treeBean;
    }

    private static Map<String, String> getReservedList() {
        Map<String, String> reservedList = new HashMap<String, String>();

        reservedList
            .put(StringEscapeUtils
                .escapeHtml3(ReservedFacilityIdConstant.INTERNAL_SCOPE),
                StringEscapeUtils
                    .escapeHtml3(ReservedFacilityIdConstant.INTERNAL_SCOPE_TEXT));

        reservedList
            .put(StringEscapeUtils
                .escapeHtml3(ReservedFacilityIdConstant.REGISTEREFD_SCOPE),
                StringEscapeUtils
                    .escapeHtml3(ReservedFacilityIdConstant.REGISTERED_SCOPE_TEXT));

        reservedList
            .put(StringEscapeUtils
                .escapeHtml3(ReservedFacilityIdConstant.UNREGISTEREFD_SCOPE),
                StringEscapeUtils
                    .escapeHtml3(ReservedFacilityIdConstant.UNREGISTEREFD_SCOPE));

        return reservedList;
    }
}
