/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.action;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.repository.util.RepositoryMappingUtil;

/**
 * 割り当てスコープビューのテーブル定義を取得するクライアント側アクションクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNodeScopeTableDefine {

    /** スコープ */
    public static final int SCOPE = 0;

    /** 初期表示時ソートカラム */
    public static final int SORT_COLUMN_INDEX = SCOPE;

    /** 初期表示時ソートオーダー */
    public static final int SORT_ORDER = 1;

    /**
     * 全てのノード一覧を取得します。<BR>
     * 
     * @return ノード一覧
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        /** 出力用変数 */
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

        /** メイン処理 */
        tableDefine.add(SCOPE, new TableColumnInfoJs(WebMessages.getString("scope", locale), 
                TableColumnInfoJs.NONE, 300, SWT.LEFT, 
                RepositoryMappingUtil.getScopeName(SCOPE)));

        return tableDefine;
    }
}