/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.action;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.repository.util.RepositoryMappingUtil;

/**
 * 登録エージェント一覧テーブルの定義を取得するクライアント側アクションクラス
 * 
 */
public class GetAgentListTableDefine {

    /** ファシリティID */
    public static final int FACILITY_ID = 0;

    /** ファシリティ名 */
    public static final int FACILITY_NAME = 1;

    /** エージェント起動時刻 */
    public static final int STARTUP_TIME = 2;

    /** エージェント最終接続時刻 */
    public static final int LAST_LOGIN = 3;

    /** new/old */
    public static final int NEW_OLD = 4;

    /** 初期表示時ソートカラム */
    public static final int SORT_COLUMN_INDEX = FACILITY_ID;

    /** 初期表示時ソートオーダー */
    public static final int SORT_ORDER = 1;

    /**
     * 全てのエージェント一覧を取得します。
     * 
     * @return エージェント一覧
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        /** 出力用変数 */
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

        /** メイン処理 */
        tableDefine.add(FACILITY_ID, new TableColumnInfoJs(
                WebMessages.getString("facility.id", locale),
                TableColumnInfoJs.FACILITY_ID, 100, SWT.LEFT,
                RepositoryMappingUtil.getAgentName(FACILITY_ID)));
        tableDefine.add(FACILITY_NAME, new TableColumnInfoJs(
                WebMessages.getString("facility.name", locale),
                TableColumnInfoJs.FACILITY_NAME, 140, SWT.LEFT,
                RepositoryMappingUtil.getAgentName(FACILITY_NAME)));
        tableDefine.add(STARTUP_TIME, new TableColumnInfoJs(
                WebMessages.getString("startup.time", locale),
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                RepositoryMappingUtil.getAgentName(STARTUP_TIME)));
        tableDefine.add(LAST_LOGIN, new TableColumnInfoJs(
                WebMessages.getString("last.login.time", locale),
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                RepositoryMappingUtil.getAgentName(LAST_LOGIN)));
        tableDefine.add(NEW_OLD, new TableColumnInfoJs(
                WebMessages.getString("update.e", locale),
                TableColumnInfoJs.NONE, 90, SWT.LEFT,
                RepositoryMappingUtil.getAgentName(NEW_OLD)));

        return tableDefine;
    }
}