/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.util;

import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.clustercontrol.ws.monitor.EventFilterInfo;
import com.clustercontrol.ws.monitor.EventDataInfo;
import com.clustercontrol.ws.monitor.FacilityNotFound_Exception;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorEndpoint;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.ScopeDataInfo;
import com.clustercontrol.ws.monitor.StatusDataInfo;
import com.clustercontrol.ws.monitor.StatusFilterInfo;
import com.clustercontrol.ws.monitor.ViewListInfo;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.EndpointManager.EndpointSetting;
import com.sun.xml.internal.ws.client.ClientTransportException;

/**
 * Hinemosマネージャとの通信をするクラス。
 * HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class MonitorEndpointWrapper {

	// ログ
	private static Log m_log = LogFactory.getLog( MonitorEndpointWrapper.class );

	public static EventDataInfo getEventInfo(String monitorId, String monitorDetailId, String pluginId, String facilityId, 
	        Long outputDate, EndpointManager endpointManager)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception, WebServiceException {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : endpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				return endpoint.getEventInfo(monitorId, monitorDetailId, pluginId, facilityId, outputDate);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getEventInfo(), " + e.getMessage(), e);
				endpointManager.changeEndpoint();
				
			}
		}
		throw wse;
	}

	public static ViewListInfo getEventList(String facilityId, EventFilterInfo filter, int messages, EndpointManager endpointManager)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception, WebServiceException {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : endpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				return endpoint.getEventList(facilityId, filter, messages);
			} catch (WebServiceException e) {
				wse = e;
				if (e instanceof ClientTransportException) {
					m_log.warn("getEventList(), " + e.getMessage());
				} else {
					m_log.warn("getEventList(), " + e.getMessage(), e);
				}
				endpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<ScopeDataInfo> getScopeList(String facilityId, boolean statusFlag, boolean eventFlag, boolean orderFlg, EndpointManager endpointManager)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception, FacilityNotFound_Exception, WebServiceException {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : endpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				return endpoint.getScopeList(facilityId, statusFlag, eventFlag, orderFlg);
			} catch (WebServiceException e) {
				wse = e;
				if (e instanceof ClientTransportException) {
					m_log.warn("getScopeList(), " + e.getMessage());
				} else {
					m_log.warn("getScopeList(), " + e.getMessage(), e);
				}
				endpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<StatusDataInfo> getStatusList(String facilityId, StatusFilterInfo filter, EndpointManager endpointManager)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception, WebServiceException {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : endpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				return endpoint.getStatusList(facilityId, filter);
			} catch (WebServiceException e) {
				wse = e;
				if (e instanceof ClientTransportException) {
					m_log.warn("getStatusList(), " + e.getMessage());
				} else {
					m_log.warn("getStatusList(), " + e.getMessage(), e);
				}
				endpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void modifyConfirm(List<EventDataInfo> list, int confirmType, EndpointManager endpointManager)
	throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MonitorNotFound_Exception, WebServiceException {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : endpointManager.getMonitorEndpoint()) {
			try {
				MonitorEndpoint endpoint = (MonitorEndpoint) endpointSetting.getEndpoint();
				endpoint.modifyConfirm(list, confirmType);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyConfirmMultiple(), " + e.getMessage(), e);
				endpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
}
