/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.ws.monitor.EventFilterInfo;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.ViewListInfo;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.monitor.MonitorConstants;
import com.necsoft.hinemos.webclient.monitor.action.GetEventListTableDefine;
import com.necsoft.hinemos.webclient.monitor.form.MonitorEventForm;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.monitor.util.EventFilterPropertyUtil;
import com.necsoft.hinemos.webclient.monitor.util.MonitorEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.PropertyUtil;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

public class GetEventListBusiness {

    public ArrayList<ArrayList<Object>> getEventList(MonitorEventForm form,
            Property condition, EndpointManager endpointManager, Locale locale)
            throws HinemosWebException {

        ViewListInfo records = null;

        if (condition == null) {
            records = getViewListInfo(form, endpointManager);
        } else {
            records = getViewListInfo(form, condition, endpointManager, locale);
        }

        ArrayList<ArrayList<Object>> listInfo = ConvertListUtil
            .eventLogDataListToArrayList(records.getEventList());
        
        doSortListLogData(form, listInfo);
        
        ConvertListUtil.sanitizeEventDataInfo(listInfo);

        return listInfo;
    }

    private ViewListInfo getViewListInfo(MonitorEventForm form,
            EndpointManager endpointManager) throws HinemosWebException {
        
        ViewListInfo records = null;
        try {
            records = MonitorEndpointWrapper.getEventList(
                    StringEscapeUtils.unescapeHtml4(form.getFacilityId()),
                    null, MonitorConstants.NUMBER_EVENT_MAX, endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (MonitorNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }
        
        return records;
    }

    private ViewListInfo getViewListInfo(MonitorEventForm form,
            Property condition, EndpointManager endpointManager, Locale locale)
            throws HinemosWebException {

        ViewListInfo records = null;
        try {
            PropertyUtil.deletePropertyDefine(condition);
            EventFilterInfo filter = EventFilterPropertyUtil.property2dto(condition, locale);
            records = MonitorEndpointWrapper.getEventList(
                    StringEscapeUtils.unescapeHtml4(form.getFacilityId()),
                    filter, MonitorConstants.NUMBER_EVENT_MAX, endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (MonitorNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        return records;
    }

    private void doSortListLogData(MonitorEventForm form,
            ArrayList<ArrayList<Object>> list) {

        // Get sorting parameter
        int sortColumnIndex = GetEventListTableDefine.SORT_COLUMN_INDEX;
        int sortOrder = GetEventListTableDefine.SORT_ORDER;
        if (form.getSidx() != null && !form.getSidx().trim().equals("")) {
            sortColumnIndex = Integer.valueOf(form.getSidx());
        }
        if (form.getSord() != null && !form.getSord().trim().equals("")) {
            sortOrder = SortOrderUtil.getSerInt(form.getSord());
        }
        // データをソート
        Collections.sort(list, new CommonTableViewerSorter(sortColumnIndex, -1,
                sortOrder));
    }
}
