/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;

import javax.xml.ws.WebServiceException;


import com.clustercontrol.ws.monitor.EventDataInfo;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.necsoft.hinemos.webclient.bean.ConfirmConstant;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.monitor.util.MonitorEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;

public class ConfirmEventBusiness {

    public boolean confirm(ArrayList<ArrayList<Object>> list,
            EndpointManager endpointManager) throws HinemosWebException {

        // イベント情報一覧を取得
        if (list != null) {
            ArrayList<EventDataInfo> eventInfoList = 
                ConvertListUtil.listToEventDataInfoList(list);

            if (eventInfoList != null && eventInfoList.size()>0) {                
                try {
                    MonitorEndpointWrapper.modifyConfirm(eventInfoList,
                            ConfirmConstant.TYPE_CONFIRMED,
                            endpointManager);
                } catch (InvalidRole_Exception e) {
                    // アクセス権なしの場合
                    throw new HinemosWebAccessException("exception.data.access");
                } catch (HinemosUnknown_Exception e) {
                    // データ一覧の取得に失敗しました
                    throw new HinemosWebException("exception.data.action");
                } catch (InvalidUserPass_Exception e) {
                    // アクセス権なしの場合
                    throw new HinemosWebAccessException("exception.data.access");
                } catch (MonitorNotFound_Exception e) {
                    // データ一覧の取得に失敗しました
                    throw new HinemosWebException("exception.data.action");
                } catch (WebServiceException e) {
                    // Hinemosマネージャより応答がありませんでした。ログアウトします。
                    throw new HinemosWebException("message.force.disconnect");
                }
                return true;               
            }
        }
        
        return false;
    }
}
