/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.necsoft.hinemos.webclient.jobmanagement.util;

import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.clustercontrol.ws.jobmanagement.HinemosUnknown_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidUserPass_Exception;
import com.clustercontrol.ws.jobmanagement.JobEndpoint;
import com.clustercontrol.ws.jobmanagement.JobForwardFile;
import com.clustercontrol.ws.jobmanagement.JobHistoryFilter;
import com.clustercontrol.ws.jobmanagement.JobHistoryList;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobInfoNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.JobMasterNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.JobNodeDetail;
import com.clustercontrol.ws.jobmanagement.JobSchedule;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.NotifyNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.UserNotFound_Exception;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.EndpointManager.EndpointSetting;
import com.sun.xml.internal.ws.client.ClientTransportException;

/**
 * Hinemosマネージャとの通信をするクラス。 HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class JobEndpointWrapper {

    // ログ
    private static Log m_log = LogFactory.getLog(JobEndpointWrapper.class);

    public static List<JobForwardFile> getForwardFileList(String sessionId,
            String jobunitId, String jobId, EndpointManager endpointManager)
            throws HinemosUnknown_Exception, InvalidRole_Exception,
            InvalidUserPass_Exception, JobInfoNotFound_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager.getJobEndpoint()) {
            try {
                JobEndpoint endpoint = (JobEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getForwardFileList(sessionId, jobunitId, jobId);
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getForwardFileList(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static JobTreeItem getJobDetailList(String sessionId,
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception,
            JobInfoNotFound_Exception, JobMasterNotFound_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager.getJobEndpoint()) {
            try {
                JobEndpoint endpoint = (JobEndpoint) endpointSetting
                        .getEndpoint();
                JobTreeItem item = endpoint.getJobDetailList(sessionId);
                setTreeParent(item);
                return item;
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getJobDetailList(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static JobTreeItem getJobTree(boolean treeOnly,
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception,
            JobMasterNotFound_Exception, NotifyNotFound_Exception,
            UserNotFound_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager.getJobEndpoint()) {
            try {
                JobEndpoint endpoint = (JobEndpoint) endpointSetting
                        .getEndpoint();
                JobTreeItem item = endpoint.getJobTree(treeOnly);
                setTreeParent(item);
                return item;
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getJobTree(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void setTreeParent(JobTreeItem item) {
        List<JobTreeItem> children = item.getChildren();
        for (JobTreeItem child : children) {
            child.setParent(item);
            setTreeParent(child);
        }
    }

    public static List<JobNodeDetail> getNodeDetailList(String sessionId,
            String jobunitId, String jobId, EndpointManager endpointManager)
            throws HinemosUnknown_Exception, InvalidRole_Exception,
            InvalidUserPass_Exception, JobInfoNotFound_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager.getJobEndpoint()) {
            try {
                JobEndpoint endpoint = (JobEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getNodeDetailList(sessionId, jobunitId, jobId);
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getNodeDetailList(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<JobSchedule> getScheduleList(
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception,
            JobMasterNotFound_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager.getJobEndpoint()) {
            try {
                JobEndpoint endpoint = (JobEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getScheduleList();
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getScheduleList(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static JobHistoryList getJobHistoryList(JobHistoryFilter filter,
            int histories, EndpointManager endpointManager)
            throws HinemosUnknown_Exception, InvalidRole_Exception,
            InvalidUserPass_Exception, JobInfoNotFound_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager.getJobEndpoint()) {
            try {
                JobEndpoint endpoint = (JobEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getJobHistoryList(filter, histories);
            } catch (WebServiceException e) {
                wse = e;
                if (e instanceof ClientTransportException) {
                    m_log.warn("getJobHistoryList(), " + e.getMessage());
                } else {
                    m_log.warn("getJobHistoryList(), " + e.getMessage(), e);
                }
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static JobInfo getJobFull(JobInfo jobInfo,
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception,
            JobMasterNotFound_Exception, NotifyNotFound_Exception,
            UserNotFound_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager.getJobEndpoint()) {
            try {
                JobEndpoint endpoint = (JobEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getJobFull(jobInfo);
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getJobFull(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }
}
