/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetJobTreeBusiness;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * This class used for get Job tree
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobTreeServlet extends CommonServlet {
    private static final long serialVersionUID = -4383433394811974899L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetJobTreeServlet.class);

    /**
     * Get Job tree
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        CommonJson result = null;

        try {
            // Load job tree
            JobTreeItem jobTreeItem = null;
            LoginManager loginManager = null;
            HttpSession session = request.getSession(true);
            GetJobTreeBusiness job = new GetJobTreeBusiness();
            
            synchronized(session) {
                loginManager = (LoginManager) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);
                jobTreeItem = job.getJobTree(loginManager.endpointManager);
            }
            
            // Create JSON
            result = job.doConvertToJson(jobTreeItem, getUserName(request));

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }

        return result;
    }
}
