/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.CssClass;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetJobTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetJobTableDefineBusiness;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * This class used for get header list
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobTableDefineServlet extends CommonServlet {

    private static final long serialVersionUID = -6712416036223172058L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetJobTableDefineServlet.class);

    /**
     * Get header list
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        CommonJson result = new CommonJson();

        try {
            GetJobTableDefineBusiness business = new GetJobTableDefineBusiness();
            ArrayList<TableColumnInfoJs> tblDefine = 
                    business.getJobTableDefine(request.getLocale());

            setModelProperties(tblDefine);

            result = DataProcess.doConvertTableDefineToJson(
                    tblDefine, true, request.getLocale(),
                    JobManagementConstants.ROW_NUM,
                    GetJobTableDefine.SORT_COLUMN_INDEX,
                    GetJobTableDefine.SORT_ORDER, true);

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }

        return result;
    }

    /**
     * @param tblDefine
     */
    private void setModelProperties(ArrayList<TableColumnInfoJs> tblDefine) {
        // Set priority class
        tblDefine.get(0).setClasses(CssClass.GRID_FIRST_COLUMN);

        tblDefine.get(GetJobTableDefine.JOB_TYPE).setFormatter(
                JsConstant.GRID_FMATTER_JOB);

        TableColumnInfoJs scope = tblDefine.get(GetJobTableDefine.SCOPE);
        scope.setFormatter(JsConstant.GRID_FMATTER_SCOPE_TYPE);
        Map<String, Object> scopeFmtOpt = new HashMap<String, Object>();
        scopeFmtOpt.put(JsConstant.GRID_FMATTER_SCOPE_TYPE_POSITION,
                GetJobTableDefine.FACILITY_ID);
        scope.setFormatoptions(scopeFmtOpt);

        tblDefine.get(GetJobTableDefine.WAIT_RULE).setFormatter(
                JsConstant.GRID_FMATTER_WAIT_RULE);

        tblDefine.get(GetJobTableDefine.CREATE_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);

        tblDefine.get(GetJobTableDefine.UPDATE_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);
    }
}