/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidDataException;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetHistoryFilterProperty;

/**
 * This class used for get History property
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetHistoryFilterPropertyBusiness {

    /**
     * Get History property
     * 
     * @return Property
     * @throws HinemosWebException
     */
    public Property getHistoryFilterProperty(Locale locale)
            throws HinemosWebException {
        // 中間変数を宣言
        Property propertyHistory = null;

        // Get history property
        GetHistoryFilterProperty historyProperty = new GetHistoryFilterProperty();
        propertyHistory = historyProperty.getProperty(locale);
        if (propertyHistory == null) {
            // フィルタ情報一覧の取得に失敗しました
            throw new HinemosWebInvalidDataException("exception.data.filter");
        }
        return propertyHistory;
    }
}