/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.common;

/**
 * EclipseのWidget Toolkitのようにコンスタントを定義するクラス (emulator)
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class SWT {
    public static final int LEAD = 1 << 14;

    public static final int LEFT = LEAD;

    public static final int TRAIL = 1 << 17;

    public static final int RIGHT = TRAIL;

    public static final int CENTER = 1 << 24;

    public static final int DOWN = 1 << 10;

    public static final int BOTTOM = DOWN;

    public static final int UP = 1 << 7;

    public static final int TOP = UP;

    public static String getHorStyle(int in) {
        String style;

        switch (in) {
        case SWT.RIGHT:
            style = "right";
            break;
        case SWT.CENTER:
            style = "center";
            break;
        default:
            style = "left";
            break;
        }

        return style;
    }
}