/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.bean;

import java.util.Locale;

import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ実行契機のタイプの定数を定義するクラス<BR>
 *
 * @version 2.4.0
 * @since 2.4.0
 */
public class JobTriggerTypeConstant {
    /** 不明 */
    public static final int TYPE_UNKOWN = 0;
    /** スケジュール */
    public static final int TYPE_SCHEDULE = 1;
    /** 手動実行 */
    public static final int TYPE_MANUAL = 2;
    /** 監視連動 */
    public static final int TYPE_MONITOR = 3;

    /**
     * 種別から文字列に変換する
     * 
     * @param type
     * @return
     */
    public static String typeToString(int type, Locale locale) {
        if (type == TYPE_SCHEDULE) {
            return WebMessages.getString("schedule", locale); //スケジュール（文字列）
        } else if (type == TYPE_MANUAL) {
            return WebMessages.getString("trigger.manual", locale); //手動実行（文字列）
        } else if (type == TYPE_MONITOR) {
            return WebMessages.getString("trigger.monitor", locale); //監視連動（文字列）
        }
        return WebMessages.getString("unknown", locale); //不明（文字列）
    }

    /**
     * 文字列から種別に変換する
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string, Locale locale) {
        if (string.equals(WebMessages.getString("schedule", locale))) {
            return TYPE_SCHEDULE;
        } else if (string.equals(WebMessages.getString("trigger.manual", locale))) {
            return TYPE_MANUAL;
        } else if (string.equals(WebMessages.getString("trigger.monitor", locale))) {
            return TYPE_MONITOR;
        }
        return -1;
    }
    
    /**
     * 文字列から種別に変換する
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string) {
        if (string.equals(WebMessages.getString("schedule", Locale.JAPAN))) { //スケジュール（文字列)
            return TYPE_SCHEDULE;
        } else if (string.equals(WebMessages.getString("trigger.manual", Locale.JAPAN))) { //手動実行（文字列）
            return TYPE_MANUAL;
        } else if (string.equals(WebMessages.getString("trigger.monitor", Locale.JAPAN))) { //監視連動（文字列)
            return TYPE_MONITOR;
        }
        return -1;
    }
}