/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.bean;

import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ファシリティのタイプ（スコープ、ノードなど）の定数クラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityConstant {
    /** コンポジット（ファシリティの種別） */
    public static final int TYPE_COMPOSITE = 2;

    /** スコープ（ファシリティの種別） */
    public static final int TYPE_SCOPE = 0;

    /** ノード（ファシリティの種別） */
    public static final int TYPE_NODE = 1;

    /** コンポジット（ファシリティの種別の文字列表現） */
    public static final String TYPE_COMPOSITE_STRING = "comp";

    /** スコープ（ファシリティの種別の文字列表現） */
    public static final String TYPE_SCOPE_STRING = "scope";

    /** ノード（ファシリティの種別の文字列表現） */
    public static final String TYPE_NODE_STRING = "node";
    
    /** コンポジット（ファシリティの種別） */
    public static final String STRING_COMPOSITE = "";

    /** スコープ（ファシリティの種別） */
    public static final String STRING_SCOPE = WebMessages.getString("scope");

    /** ノード（ファシリティの種別） */
    public static final String STRING_NODE = WebMessages.getString("node");

    /**
     * 種別から文字列に変換します。<BR>
     * 
     * @param type
     * @return
     */
    public static String typeToString(int type) {
        if (type == TYPE_COMPOSITE) {
            return STRING_COMPOSITE;
        } else if (type == TYPE_SCOPE) {
            return STRING_SCOPE;
        } else if (type == TYPE_NODE) {
            return STRING_NODE;
        }
        return "";
    }

    /**
     * 文字列から種別に変換します。<BR>
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string) {
        if (string.equals(STRING_COMPOSITE)) {
            return TYPE_COMPOSITE;
        } else if (string.equals(STRING_SCOPE)) {
            return TYPE_SCOPE;
        } else if (string.equals(STRING_NODE)) {
            return TYPE_NODE;
        }
        return -1;
    }
}