/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create agent of repository
 */
var fn = function(_view){
	var __ = cm
	,_pers = this
	;
	
	 var view = $.extend({}, __._fnview_grid, {
		/*
		 * Get agent list
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_agent_list_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					var grid = _.grid
					,pager   = grid.$pgr
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Set some options for grid
					$.extend(data_respond,{
						url         : "get_agent_list"
						,pager      : pager
						,caption    : "&nbsp;"
						,viewrecords: true
					});
				
					grid.processData(data_respond, ['facilityId']);
					grid.controlSize();
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _  = this
			,_btns = _.$btns
			,_grid = _.grid
			;
			
			// Bind update grid data
			_btns.children("#update").click(function(){
				_.grid.refreshData(null, true);
			});
		}
	});
	
	return view;
};