/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create monitor event
 */
var fn = function (_view){
	var __ = cm
	,_pers = this
	
	// Constant
	,TYPE_CONFIRMED   = 1
	,TYPE_UNCONFIRMED = 0
	;
	
	 var view = $.extend({}, __._fnview_tree_grid, {
		load_flg    : false
		,facility_id: ""
		,
		/*
		 * Set caption of grid
		 */
		setCaption: function(path){
			var _    = this
			,caption = [__.getLang("scope"), ": " , path].join("")
			;
			
			// Check filter
			if(!(_.filter_active)){
				_.grid.setCaption(caption);
			}
			
			// Store caption
			_._caption = caption;
		}
		
		,/*
		 * On click a node of tree
		 */
		onclickTree: function(node_data){
			var _ = this
			;
			_.facility_id = node_data.facilityId;
			// Set caption
			_.setCaption(node_data.path);
			
			if (!(_.load_flg)) {
				_.load_flg = true;
				_.reloadGrid();
			}
		}
		,
		/*
		 * reload Grid
		 */
		reloadGrid: function(){
			var _ = this
			;
			
			_.grid.refreshData({
				facilityId: _.facility_id
			});
		}
		,/*
		 * Get status list
		 */
		createGrid: function(){
			var _ = this;
			
			var caption = _._caption = [__.getLang("scope"), ": "].join("");
			
			$.ajax({
				url      : "get_event_list_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					// Cache local variants
					var grid = _.grid
					,pager   = grid.$pgr
					,$mn = grid.siblings("#menu_rightclick").children("ul:first")
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Set some options for grid
					$.extend(data_respond, {
						url              : "get_event_list"
						,pager           : pager
						,caption         : caption
						,sortable        : true
						,viewrecords     : true
						,multiselect     : true
						,multiselectWidth: 100
						,loadComplete    : function(row_id){
							var post_data = grid.getGridParam("postData")
								,facility_id
								;
							if((facility_id = post_data.facilityId) === undefined){
								facility_id = "";
							}
							if(facility_id === _.facility_id){
								_.load_flg = false;
							}else{
								setTimeout(function(){
									_.reloadGrid();
								}, 1);
							}
							// Set refresh data
							_view.setRefresh();
							
							// Clear post data action
							grid.setGridParam({
								postData: {
									action     : ""
									,actionData: ""
									,numData   : ""
								}
							});
							
							// Disable button "detail"
							if(grid.getGridParam("selarrrow").length != 1) {
								_.$btns.children("#detail").attr("disabled", true);
							}
							// Disable button "confirmed"
							if(_.getRowsUnconfirmed().length <= 0){
								_.$btns.children("#confirmed").attr("disabled", true);
							}
							// Set priority bar
							_.setPriorityStatusBar();
						}
						,ondblClickRow   : function(row_id){
							grid.jqGrid("resetSelection");
							grid.jqGrid("setSelection", row_id, false);
							_.getDetail();
						}
						,beforeSelectRow : function (row_id, e) {
							if (e.shiftKey) { // Select from a b
								if(grid.init_list_row_id === undefined){
									// init_list_row_id hasn't initialized yet
									grid.init_list_row_id = row_id;
									return true;
								}
								
								// row_id: type string
								var init_list_row_id = grid.init_list_row_id // type string
								,init_index   = grid.jqGrid("getInd", init_list_row_id) // type number
								,cur_index    = grid.jqGrid("getInd", row_id)
								,start_select = false
								;
								
								// Clear list selection
								grid.jqGrid("resetSelection");
								
								if(init_index == cur_index){
									return true;
								} else {
									if (init_index < cur_index) {
										$.each(grid.getDataIDs(), function(key, value){
											// value: type string
											if(value == row_id){
												// The end, not select this row
												//   which is on click because, this action will bind after
												return false;
											}
											
											if (start_select || (start_select = (value == init_list_row_id))){
												grid.jqGrid("setSelection", value, false);
											}
											
											return true;
										});
									} else {
										$.each(grid.getDataIDs(), function(key, value){
											if (start_select){
												grid.jqGrid("setSelection", value, false);
												return (value != init_list_row_id);
											}
											
											if(value == row_id){ // Start line: not set
												start_select = true;
											}
											return true;
										});
									}
								}
							} else {
								if(!e.ctrlKey) { // Select one
									grid.jqGrid("resetSelection");
								}
								
								grid.init_list_row_id = row_id; // Remove start shift
							}
							return true;
						}
						,onSelectRow     : function(row_id, e){
							var selrows = grid.getGridParam("selarrrow")
							,length = selrows.length
							,$btns  = _.$btns
							;
							
							// Store onclick row_id
							grid.onclick_row_id = row_id;
							
							// Check for setting status  of detail button
							if(length != 1){
								$btns.children("#detail").attr("disabled", true);
							}else{
								// Actually, length = 1, because when the action
								// onSelectRow, at least, the grid has a row
								// which is selected
								$btns.children("#detail").attr("disabled", false);
							}
							
							if(_.getRowsUnconfirmed().length > 0){
								$btns.children("#confirmed").attr("disabled", false);
							}else{
								$btns.children("#confirmed").attr("disabled", true);
							}
						}
						,gridComplete: function(){
							// Set title agent: td.marker-cell-datetime-precise
							_.grid.find("td.marker-cell-datetime-precise")
								.each(function(){
									var i = this
									,title
									;
									
									// Get and set title again
									if(title = i.title){
										title = title.split("#")[0];
										i.title = title;
									};
								});
						}
					});
					
					grid.processData(data_respond, ['monitorId', 'pluginId', 'facilityId', 'receiveTime']);
					grid.hideCol("cb"); // Hide check box
					grid.controlSize();
					
					// Bind context menu for grid(right click)
					grid.contextMenu(
						"menu_rightclick"
						,{
							onContextMenu: function(event, menu){
								var row_id = $(event.target).closest("tr").attr("id")
								,selrows   = grid.getGridParam("selarrrow")
								;
								
								if(selrows.length){
									if($.inArray(row_id, selrows) == -1){
										grid.jqGrid("resetSelection");
									}else{
										grid.jqGrid("setSelection", row_id, false);
									}
								}
								
								// After this action happen, it will call onSelectRow
								grid.jqGrid("setSelection", row_id, true);
								grid.init_list_row_id = row_id;
								
								// Bind for content
								if(_.getRowsUnconfirmed().length > 0){
									$mn.children("#confirmed").removeClass("ui-state-disabled");
								}else{
									$mn.children("#confirmed").addClass("ui-state-disabled");
								}
                                
                                if(grid.getGridParam("selarrrow").length != 1) {
                                    $mn.children("#detail").addClass("ui-state-disabled");
                                }else{
                                    $mn.children("#detail").removeClass("ui-state-disabled");
                                }
                                
								return true;
							}
							,container   : grid.$ctn
							,bindings    : {
								detail    : function(){
									_.getDetail();
								}
								,confirmed: function(e){
									_.confirmAction();
									return true;
								}
							}
						}
					);
				}
				,error   : __.loadDataError
			});
		}
	 	
		,/*
		 * Get facility tree
		 */
		getTree: function(){
			return __.fclt_tree.get(this._id);
		}
		
		,/*
		 * Reset data of panes of views
		 */
		resetView: function(tree){
			var _ = this;
			
			_.tree.refreshData(tree);
			_.facility_id = "";
			_.grid.refreshData({
				facilityId: ""
			}, true);
			
			_.setCaption("");
		}
		
		,/*
		 * Refresh data
		 */
		refreshData: function(){
            /** Bug_11 */
			this.grid.refreshData(null, true);
            /***********/
		}
		
		,/*
		 * Create dialogs
		 */
		createDialog: function(){
			// Cache local variant
			var _ = this;
			
			// Declare detail dialog
			__.crePropInfoDlg.call(_, "detail", {
				option: {
					title   : _pers.getTitle("events_info")
					,width  : 410
					,height : 480
					,buttons: [
						{
							text  : __.getLang("cancel")
							,click: function(){
								$(this).dialog("close");
							}
						}
					]
				}
				,url  : "get_event_info_property"
				,body : { // action for grid of this dialog
					loadComplete : function(data_respond){
						if (__.checkJsonError(data_respond) === false){
							return;
						}
						_.detail.controlSize();
					}
					,loadError   : __.loadDataError
					,gridComplete: function(){
						var $gr = $(this);
						
						$gr.find("button.btn-in-cell").each(function(){
							$(this).click(function(e){
								var $i = $(this)
								,$div  = $i.siblings("div:first")
                                ,$title = $i.parent().siblings("td:first")
								;
								if($div.length != 0){
									__.openTextDlg({
										content: __.replaceUrlWithHtmlLinks($div.children("span:first").html(), true)
										,title : $title.html()
									});
								}
								
								e.stopPropagation();
							});
						});
						
						$gr.find("div.container-message").each(function(){
							$(this).click(function(e){
								var $i = $(this)
								,$btn  = $i.siblings("button:first")
								;
								
								$btn.css("display", "inline-block");
							});
						});
					}
					,onSelectRow: function(){
						$(this).find("tr:not(:.ui-state-highlight) button")
							.css("display", "none");
						;
					}
				}
			});
			
			// Declare filter dialog
			__.crePropActnDlg.call(_, "filter", {
				option: {
					title   : _pers.getTitle("filter_events")
					,width  : 400
					,height : 400
					,open   : function(){
						$(this).siblings('div.ui-dialog-buttonpane:first').find("button:eq(1)").focus();
					}
					,buttons: [
						{
							text  : __.getLang("clear")
							,click: function(){
								_.filter.reset("filter");
							}
						}
						,{
							text  : __.getLang("ok_o")
							,click: function(){
								_.filter.execute(function(post_data){
									var _ = this;
									
									// Extend filter is true
									$.extend(post_data, {filter: true});
									
									// Refresh data
									/** Bug_11 */
									_.grid.refreshData(post_data, true);
									/***********/
									// Set caption
									_.grid.setCaption(__.getLang("filtered_list"));
									
									// Store filter active
									_.filter_active = true;
									
									// Add class button active
									_.$btns.children("#filter").addClass("ui-button-active");
								});
								
								$(this).dialog("close");
							}
						}
						,{
							text  : __.getLang("cancel")
							,click: function(){
								_.filter.storeValues();
								$(this).dialog("close");
							}
						}
					]
				}
				,url  : "get_event_filter_property"
			});
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _ = this
			,btns = _.$btns
			,grid = _.grid
			;
			
			// Bind actions for button in left of pane
			// Bind detail
			btns.children("#confirmed").click(function(){
				_.confirmAction();
			});
			
			// Bind detail
			btns.children("#detail").click(function(){
				_.getDetail();
			});
			
			// Bind filter
			btns.children("#filter").click(function(){
				if(_.filter_active){
					// Inactive filter for filter grid
					/** Bug_11 */
					grid.refreshData({filter: false}, true);
					/***********/
					grid.setCaption(_._caption);
					
					// Process CSS for button
					$(this).removeClass("ui-button-active");
					_.filter_active = false;
				}else{
					// Open dialog which contain filter property grid
					_.filter.open();
				}
			});
			
			// Bind update grid data
			btns.children("#update").click(function(){
				/** Bug_11 */
				_.grid.refreshData(null, true);
				/***********/
			});
			
			// Bind toggle left pane
			btns.children("#toggle_view").click(function(){
				_.togglePane("west", this);
			});
		}
		
		,/*
		 * Get row data
		 */
		getDetail: function(){
			var _   = this
			,grid   = _.grid
			,row_id = grid.getGridParam("selrow")
			;
			if(row_id == null || row_id <= 0){
				row_id = grid.onclick_row_id;
			}	
			if(row_id){
				var detail = _.detail
				,row_data  = grid.getRowData(row_id)
				;
				
				// Set post data
				detail.setPostData({
					monitorId   : $.jgrid.htmlEncode(row_data.monitorId)
					,monitorDetailId   : $.jgrid.htmlEncode(row_data.monitorDetailId)
					,pluginId   : $.jgrid.htmlEncode(row_data.pluginId)
					,facilityId : $.jgrid.htmlEncode(row_data.facilityId)
					,receiveTime: row_data.receiveTime
				});
				
				// Open dialog
				detail.open();
			}
		}
		
		,/*
		 * Get rows in selection list have confirmed value is unconfirmed 
		 */
		getRowsUnconfirmed: function(){
			var _     = this
			,list     = []
			,col_name = "confirmed"
			,grid     = _.grid
			,selrows  = grid.getGridParam("selarrrow")
			,cnt_row  = selrows.length
			;
			
			while(cnt_row--){
				var row_id = selrows[cnt_row];
				if(grid.getCell(row_id, col_name) == TYPE_UNCONFIRMED){
					list[list.length] = row_id;
				}
			}
			
			return list;
		}
		
		,/*
		 * Action for confirm
		 */
		confirmAction: function(){
			var _    = this
			,grid    = _.grid
			,list    = _.getRowsUnconfirmed()
			,cnt_row = list.length
			;
			
			if(cnt_row > 0){
				// Initialize post data with name of action is confirmed
				var act_data = [];
				while(cnt_row--){
					var row_id = list[cnt_row]
					,row_data  = grid.getRowData(row_id)
					,post_row  = {};
					;
					for (var col_nm in row_data){
						var value = row_data[col_nm];
						post_row[col_nm] = $.jgrid.htmlEncode(value);
					}
					act_data[cnt_row] = post_row;
				}
				
				// Confirmed action
				grid.refreshData({
					actionData: act_data
					,action   : "confirmed"
					,numData  : act_data.length
				});
			}
		}
	});
		
	 return view;
};