/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Get and show data of job
 */
var fn = function(){
	var __ = cm
	,_pers = this
	/** Bug_154 */
	,load_tree = false
	/***********/
	;
	
	
	 var view = $.extend({}, __._fnview_tree_grid, {
		/*
		 * Set caption of grid
		 */
		setCaption: function(path){
			this.grid.setCaption([__.getLang("job"), ": " , path].join(""));
		}
		
		,/*
		 * On click a node of tree
		 */
		onclickTree: function(node_data){
			var _ = this
			,grid = _.grid
			,data = []
			,children
			;
			
			// Get children of data
			if(node_data && (children = node_data.children)
					&& $.isArray(children)){
				var len = children.length;

				// Get jobData of children
				for(var cnt = 0; cnt < len; cnt++){
					data[cnt] = children[cnt].jobData;
				}
			}
			
			// Clear grid data before setting new data for grid
			grid.clearGridData();
			grid.setGridParam({data: data}).trigger("reloadGrid");
			
			// Set caption
			_.setCaption(node_data.path);
		}
		
		,/*
		 * Get scope list
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_job_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					// Cache local variants
					var grid = _.grid
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Set some options for grid
					$.extend(data_respond,{
						datatype: "local"
						,caption: [__.getLang("job"), ": "].join("")
					});
				
					grid.processData(data_respond);
					grid.controlSize();
				}
				,error   : __.loadDataError
			});
			/** Bug_154 */
			if(load_tree == false)
			{
				load_tree = _.update(_);
			}
			/***********/
		}
		
		,/*
		 * Get job tree
		 */
		getTree: function(){
			return _pers.job_tree.get();
		}
		
		,
		/** Bug_154 */
		/*
		 * Update data for tree 
		 */
		update: function(_){
			
			__.jobmanagement.list.content.tree.append($("<div class='tree-loading'></div>"));
			_pers.job_tree.getData();
			
			return true;
		}
		/***********/
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _     = this;
			var _btns = _.$btns;
			
			// Bind actions for button in left of pane
			// Bind toggle left pane
			_btns.children("#toggle_view").click(function(){
				_.togglePane("west", this);
			});
		}
	});
	
	return view;
};