/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Create (job management) JOB_DETAIL
 */
var fn = function(_view){
	var __ = cm
	,_pers = this
	;
	
	var view = $.extend({}, __._fnview_grid, {
		session_id: ""
		,load_flg    : false

		,/*
		 * Set caption of grid
		 */
		setCaption: function(){
			var _ = this;
			
			_.grid.setCaption([__.getLang("session_id"), ": " , _.session_id].join(""));
		}
		
		,/*
		 * Update node detail
		 */
		updateNodeDetail: function(session_id, job_id, jobunit_id){
			var _ = this
			,vw_dtl
			;
			
			// Check whether view "node detail" exists
			if(!(vw_dtl = _pers["node_detail"])){
				return;
			}
			
			// Update data for view
			vw_dtl.updateData({session_id: session_id, job_id: job_id, jobunit_id: jobunit_id});
		}
		
		,/*
		 * Update forward file
		 */
		updateForwardFile: function(session_id, job_id, jobunit_id){
			var _ = this
			,vw_dtl
			;
			
			// Check whether view "forward file" exists
			if(!(vw_dtl = _pers["forward_file"])){
				return;
			}
			
			// Update data for view
			vw_dtl.updateData({session_id: session_id, job_id: job_id, jobunit_id: jobunit_id});
		}
		
		,/*
		 * Update data when click on view 'history' content
		 */
		updateData: function(){
			var _ = this;

			// call reloadGrid function 
			if (!(_.load_flg)) {
				_.load_flg = true;
				_.reloadGrid();
			}
		}
		
		, /*
		 * reload data when click on view 'history' content
		 */
		reloadGrid: function(){
			var _       = this 
			,session_id = _view.__session_id
			,grid       = _.grid
			;
			// Case updating
			_.session_id = session_id;
			
			// Set caption
			_.setCaption();
			
			// Clear selection
			grid.resetSelection();
			// Check to clear?
			if(session_id === ""){
				grid.clearGridData();
				
				// Clear data of views which belong this view
				_.updateNodeDetail("", "", "");
				_.updateForwardFile("", "", "");
                _.load_flg = false;
				return;
			}
			$("#load_grid_jobmanagement_job_detail").show();
			// Reload grid
			grid.refreshData({sessionId: session_id});
		}
		
		,/*
		 * Get scope list
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_job_detail_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					var grid   = _.grid
					,post_data = {}
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Check session_id of view: control
					if(_view.__session_id){
						_.session_id = _view.__session_id;
						
						post_data.sessionId = _.session_id;
					}
					
					// Set some options for grid
					$.extend(data_respond, {
						caption         : "&nbsp;"
						,url            : "get_job_detail"
						,treeGrid       : true
						,treeGridModel  : "adjacency"
						,ExpandColumn   : "tree"
						,treeIcons      : {
							plus  :"ui-icon-hnm-plus"
							,minus:"ui-icon-hnm-minus"
							,leaf :"ui-icon-hnm-none"
						} 
						,postData       : post_data
						,ajaxGridOptions: {
							// This function prevent grid send request without 
							//   sessionId or sessionId = "" 
							beforeSend: function (jqXhr, settings){
								var str_params = settings.data // form: a=b&c=d ...
								,params = str_params.split("&")
								,count  = params.length
								;
								
								// Check every parameter (form: a=b) 
								while(count--){
									var str_param = params[count]
									,param = str_param.split("=")
									;
									
									// Check parameter:
									if(param[0] && (param[0] == "sessionId") && (param[1])){
										return true;
									}
								}
								
								return false;
							}
						}
						,loadComplete   : function(){
							var session_id = _view.__session_id;
							// Job[NodeDetail] and Job[ForwardFile] after 
							// Job[JobDetail] loaded
							
							// Clear data of views which belong this view
                            //_.updateNodeDetail("", "", "");
							//_.updateForwardFile("", "", "");

							var curent_session_id = _pers["node_detail"].__session_id;
							var curent_jobunit_id = _pers["node_detail"].__jobunit_id;
							var curent_job_id     = _pers["node_detail"].__job_id;

							if (curent_jobunit_id !== undefined && curent_jobunit_id.length > 0
								&& curent_session_id !== undefined && curent_session_id.length > 0
								&& curent_job_id !== undefined && curent_job_id.length > 0) {
                            
								var in_job_detail = $(grid).find('tr').filter(function(){
									return ($(this).find('td:nth-child(5)').first().text() == curent_job_id && 
											$(this).find('td:nth-child(7)').first().text() == curent_jobunit_id);
								});
								
								_.updateNodeDetail("", "", "");
								_.updateForwardFile("", "", "");
								
								if (curent_session_id == _.session_id && in_job_detail.length > 0) {
									var row_id = $(in_job_detail[0]).attr('id');
									grid.jqGrid('setSelection',row_id);
									_.updateNodeDetail(curent_session_id, curent_job_id, curent_jobunit_id);
									_.updateForwardFile(curent_session_id, curent_job_id, curent_jobunit_id);
								}
							}
							
							if(session_id === _.session_id){
								_.load_flg = false;
							}else{
								setTimeout(function(){
									_.reloadGrid();
								}, 1);
							}
						}
						,onSelectRow    : function(row_id){
							var i     = this
							,row_data = $(i).getRowData(row_id)
							,session_id = _.session_id
							,job_id     = $.jgrid.htmlEncode(row_data.jobId)
							,jobunit_id = $.jgrid.htmlEncode(row_data.jobunitId)
							;
							
							_.updateNodeDetail(session_id, job_id, jobunit_id);
							_.updateForwardFile(session_id, job_id, jobunit_id);
						}
					});
					
					grid.processData(data_respond);
					grid.controlSize();
					_.setCaption();
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			
		}
	});
	
	return view;
};