/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create (job management) FORWARD_FILE/FILE_TRANSFER
 */
var fn = function(_view){
	var __ = cm
	,_pers = this
	;
	
	var view = $.extend({}, __._fnview_grid, {
		session_id : ""
		,job_id    : ""
		,jobunit_id: ""
		
		,/*
		 * Set caption of grid
		 */
		setCaption: function(){
			var _ = this;
			
			_.grid.setCaption([
				__.getLang("session_id"), ": " , _.session_id
				,",&nbsp;"
				,__.getLang("job_id"), ": " , _.job_id
			].join(""));
		}
		
		,/*
		 * Update data when click on view 'history' content
		 */
		updateData: function(){
			var _       = this 
			,session_id = _view.__session_id
			,job_id     = _view.__job_id
			,jobunit_id = _view.__jobunit_id
			,grid       = _.grid
			;
			
			// Check for update data
			if((session_id === _.session_id) 
				&& (job_id === _.job_id)
				&& (jobunit_id === _.jobunit_id)){
				return;
			}
			
			// Get new value of session_id and job_id
			_.session_id = session_id;
			_.job_id     = job_id;
			_.jobunit_id = jobunit_id;
			_.setCaption();
			
			// Check to clear?
			if((session_id == "")
				|| (job_id == "")
				|| (jobunit_id == "")
				){
				grid.clearGridData();
				return;
			}
			
			$("#load_grid_jobmanagement_forward_file").show();
			// Reload grid
			grid.refreshData({sessionId: session_id, jobId: job_id, jobunitId: jobunit_id});
		}
		
		,/*
		 * Get grid data
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_forward_file_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					var grid   = _.grid
					,post_data = {}
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Check session_id of view: control
					if(_view.__session_id){
						_.session_id = _view.__session_id;
						
						post_data.sessionId = _.session_id;
					}
					
					if(_view.__job_id){
						_.job_id = _view.__job_id;
						
						post_data.jobId = _.job_id;
					}
					
					if(_view.__jobunit_id){
						_.jobunit_id = _view.__jobunit_id;
						
						post_data.jobunitId = _.jobunit_id;
					}
					
					// Set some options for grid
					$.extend(data_respond, {
						caption         : "&nbsp;"
						,url            : "get_forward_file"
						,postData       : post_data
						,ajaxGridOptions: {
							// This function prevent grid send request without 
							//   sessionId or sessionId = "", jobId = "", jobunitId = ""
							beforeSend: function (jqXhr, settings){
								var str_params = settings.data // form: a=b&c=d ...
								,params    = str_params.split("&")
								,cnt_param = params.length
								,sum_check = 3 // Check 2 parameter
								,cnt_check = 0 // Initialize value of counter of check
								;
								
								// Check every parameter (form: a=b)
								
								while(cnt_param--){
									var str_param = params[cnt_param]
									,param = str_param.split("=")
									;
									
									// Check parameter:
									if(param[0] && param[1]){
										if((param[0] == "sessionId")
											|| (param[0] == "jobId")
											|| (param[0] == "jobunitId")){
											cnt_check++;
										}
									}
									
									// Sum of parameter is ok
									if(cnt_check == sum_check){
										return true;
									}
								}
								
								return false;
							}
						}
					});
					
					grid.processData(data_respond);
					grid.controlSize();
					_.setCaption();
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			
		}
	});
	
	return view;
};