/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Language definition
 */
(function(__){
	var lang = {
		about_web        : "${menu.help.about.web}"
		,abnormal        : "${abnormal}"
		,attribute       : "${lang.attribute}"
		,calendar        : "${calendar}"
		,cancel          : "${lang.cancel}"
		,clear           : "${lang.clear}"
		,close           : "${lang.close}"
		,confirm_login   : "${message.accesscontrol.17}"
		,confirmed       : "${confirmed}"
		,datepicker      : {
			dayNamesMin     : (new String("${datetimepicker.dayNamesMin}")).split(",")
			,monthNamesShort: (new String ("${datetimepicker.monthNamesShort}")).split(",")
			,prevText       : "${datetimepicker.prevText}"
			,nextText       : "${datetimepicker.nextText}"
		}
		,datetimepicker  : {
			dateFormat      : "${datetimepicker.dateFormat}"
			,title          : __.getIconStrTitle("${datetimepicker.title}")
			,timeLabel      : "${datetimepicker.timeLabel}"
			,changeMonth    : true
			,changeYear     : true
			,showOn         : "button"
			,buttonImage    : "images/calendar.gif"
			,buttonImageOnly: true
			,showButtonPanel: true
			,closeText      : "${datetimepicker.closeText}"
			,currentText    : "${datetimepicker.currentText}"
			,dayNamesMin    : (new String("${datetimepicker.dayNamesMin}")).split(",")
			,monthNamesShort: (new String ("${datetimepicker.monthNamesShort}")).split(",")
			,prevText       : "${datetimepicker.prevText}"
			,nextText       : "${datetimepicker.nextText}"
		}
		,day_names       : (new String("${day.names}")).split(",")
		,error_timeout   : "${message.sessiontimeout}"
		,error_connection: "${message.force.disconnect}"
		,facility_id     : "${facility.id}"
		,facility_name   : "${facility.name}"
		,failed          : "${failed}"
		,filtered_list   : "${filtered.list}"
		,invalid         : "${invalid}"
		,job             : "${job}"
		,job_id          : "${job.id}"
		,message         : "${message}"
		,minute          : "${minute}"
		,month_names     : (new String("${month.names}")).split(",")
		,monthday        : "${monthday}"
		,name            : "${lang.name}"
		,no              : "${lang.no}"
		,notify_id       : "${notify.id}"
		,notify_type     : "${notify.type.list}"
		,ok_o            : "${lang.ok_o}"
		,open_perspective: "${open.perspective}"
		,open_perspective_title: "${open.perspective.title}"
		,period_format   : "${js.format.period}"
		,scope           : "${lang.scope}"
		,select_job      : "${select.job}"
		,select_job_errormsg_title : "${select.job.errormsg.title}"
		,select_row      : "${select.row}"
		,session_id      : "${session.id}"
		,schedule_id     : "${schedule.id}"
		,specify_job     : "${message.job.1}"
		,specified_period: "${specified.period}"
		,valid           : "${valid}"
		,value           : "${lang.value}"
		,warning         : "${warning}"
		,yes             : "${lang.yes}"
		,message_org     : "${message.org}"
		,comment         : "${comment}"
		,perspectiveP    : "${perspectiveP}"
		,leftBracket     : "${left.bracket}"
		,rightBracket    : "${right.bracket}"
	}
	;
	
	__.getLang = function(key, deep) {
		// Cache 'language' variant
		
		// Check whether key is valid
		if(!(key && ((typeof key) == "string"))){
			return;
		}
		
		// Split key and get length
		if(deep !== true){
			// Only get the first level of language(default)
			if(lang[key]){
				return lang[key];
			}else{
				return key;
			}
		}else{
			// Get internal value of language
			var arr  = key.split(".") // Get array of key
			,len_dp  = arr.length     // Length deep
			,in_lang
			;
			
			// Get the first level
			if(!(in_lang = lang[arr[0]])){
				return key;
			}
			
			// Get deep of language value
			for(var cnt = 1; cnt < len_dp;){
				if(!(in_lang = in_lang[arr[cnt++]])){
					return key;
				}
			}
			return in_lang;
		}
		
	};
	
})(cm);