/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Main function
 */
(function(__){
	$.extend(__, {
		/********************************************************
		 * Menus
		 */
		/*
		 * Hide header menu
		 */
		hideSubHeader: function(){
			var __ = this
			,__hdr = __.$hdr
			;
			if(__hdr.getActive()){
				__hdr.trigger("hide");
				__.$layout.resetOverflow(__hdr);
			}
		}
		
		,/*
		 * Hide menus for some events will stopPropagation
		 */
		hideDefaultNoneDisplay: function(){
			var ctx_mn
			,hdr_mn_fn
			;
			// Hide contextMenu
			if(ctx_mn = $.contextMenu){
				ctx_mn.hide();
			}
			
			// Hide header menu
			if(hdr_mn_fn = __.hideSubHeader){
				hdr_mn_fn.call(__);
			}
			
			// Hide button which is contained by a grid cell
			$("button.btn-in-cell:visible").each(function(){
				var $i = $(this);
				if($i.hasClass("btn-display-marker")){
					$i.removeClass("btn-display-marker");
				}else{
					$i.css("display", "none");
				}
			}); 
		}
		
		/********************************************************
		 * Tab properties
		 */
		,/*
		 * Add tab to main tab
		 */
		addTab: function(per_nm){
			// Cache local variants
			var __  = this
			,__ctn  = __.$ctn
			,selr   = __.per2Selr(per_nm)
			,content
			,__per
			;
			
			// Check whether 'per_nm' was declared
			if(!(__per = __[per_nm])){
				return;
			}
			
			if(!__per.content){
				// Add perspective to common with its reference
				// CONTENT
				content = {};
				__per.content = content;
				
				// Add tab
				__ctn.tabs("add", selr, __per._title, 0);
				__ctn.tabs("select", selr);
				
				// Create perspective
				$.extend(
					content
					,__._fnper
					,{
						_id  : per_nm
						,$ctn: __ctn.find(selr).html("") // Clean HTML
					}
				);
				
				// Initialize perspective
				content.init();
			}else{
				// If tab is active, set selecting for perspective
				__ctn.tabs("select", selr);
			}
		}
		
		,/*
		 * Create and open
		 */
		createDialog: function(p_dlg){
			var dir
			,nms = p_dlg.split(".")
			;
			
			// Check length
			if(nms.length < 2){
				return;
			}
			
			// Check 'path'
			if(!(dir = __[nms[0]])){
				return;
			}
			
			// Check validation of name
			if(!(dir[nms[1]])){
				return;
			}
			
			// Call function
			dir.createDialog(nms[1]); // Create the first dialog
		}
		
		,/*******************************************************
		 * Common action
		 */
		/*
		 * Get current perspective display
		 */
		getActiveTab: function(){
			var __ = this
			,selr  = __.$ctn_hdr.children("li.ui-tabs-selected:first")
						.children("a:first").attr("href")
			;
			
			// Check selector is get
			if(selr){
				return __.selr2Per(selr)
			}
			
			return false;
		}
		
		,/*
		 * Add view to active perspective
		 */
		addView: function(vw_nm){
			var __  = this
			,__ctn  = __.$ctn
			,per_nm = __.getActiveTab()
			;
			// Check id
			if(per_nm){
				__[per_nm].content.addView(vw_nm);
				return true;
			}
			
			return false;
		}
		
		,/********************************************************
		 * Main actions
		 *******************************************************/
		/*
		 * Initialize all
		 */
		init: function(){
			var __     = this
			,$body     = $("body")
			,__hdr     = $body.find("#header_menu:first")
			,__ctn     = $body.children("#page_container")
			,__ftr     = $body.children("#page_footer")
			,__ctn_hdr = __ctn.children("ul:first")
			,__layout  = $body.layout({
				north__spacing_open : 0
				,south__spacing_open: 0
				,north__size        : 23
				,south__size        : 25
				,enableCursorHotkey : false
				,showErrorMessages  : false
			})
			;
			
			/******************************************
			 * Cache layout: header, container, footer
			 *****************************************/
			$.extend(__, {
				$layout  : __layout
				,$hdr    : __hdr
				,$ctn    : __ctn
				,$ftr    : __ftr
				,$ctn_hdr: __ctn_hdr
			});
			
			/******************************************
			 * The first loading facilityTree
			 *****************************************/
			__.fclt_tree.getData();
			
			/******************************************
			 * Get perspective dialog
			 *****************************************/
			$("head").append([
  				"<script type='text/javascript' src='js/common/perspectiveDialog.js'></sc",
  				"ript>"
  			].join(""));
			
			/******************************************
			 * Create header menu
			 *****************************************/
			$("head").append([
				"<script type='text/javascript' src='js/common/createHeader.js'></sc",
				"ript>"
			].join(""));
			
			/******************************************
			 * Initialize tab layout
			 *****************************************/
			__ctn.tabs({
				tabTemplate   : [
						"<li><a href='#{href}' title=''>"
						,__.getIconStr("ui-icon-hnm-perspective")
						,"#{label}</a></li>"
					].join("")
				,panelTemplate: "<div class='per-container'><div>"
				,select       : function(event, ui){
					__.hideDefaultNoneDisplay();
				}
				/**Show title for perspective*/
				,add       : function(event, ui){
					var $pan = ui.jquery ? ui : $(ui.panel)
						,$tab = ui.jquery ? ui : $(ui.tab)
						,per_nm  = __.selr2Per(["#", $pan.attr("id")].join(""))
						,per     = __[per_nm]
						,title   = per._title
						,perText = __.getLang("perspectiveP")
						,open = __.getLang("leftBracket")
						,close = __.getLang("rightBracket")
						;
					title = open + title + close + perText;
					$tab.attr("title", title) ;
				}
				/*****************************/
				,show         : function(event, ui){
					var $pan = ui.jquery ? ui : $(ui.panel)
					,per_nm  = __.selr2Per(["#", $pan.attr("id")].join(""))
					,per     = __[per_nm]
					;
					// Property 'display' is set into 'none' when layout resize
					if($pan.css("display") != "block"){
						$pan.css("display", "block");
						$pan.data("layout").resizeAll();
					}
					
					// Find the views which is selector but their content belong
					// another perspective (it empty)
					$pan.find("div.view-container(:empty)").not(".ui-tabs-hide")
						.each(function(){
							var vw_id = this.id
							,vw_ctrl  = per.content.getViewCtrlFromId(vw_id)
							,view     = __[vw_ctrl[0]][vw_ctrl[1]]
							;
							
							// Is it possible the display status of this view is none?
							if(view._belong != per_nm){
								var $_pan = $(this)
								,content  = view.content
								,$btns    = content.$btns
								,$layout  = content.$layout
								;
									
								// Renew _belong
								view._belong = per_nm;
								
								// Move content of view
								$_pan.html($layout.detach());
								
								// Move buttons
								$btns.detach().appendTo($_pan
									.siblings("ul.header-panel:first")
										.children(".ins-right-tab:first"));
								
								// Set container again
								content.$ctn = $_pan;
								
								// Show buttons of this tabs and set no display for others' buttons
								$btns.css("display", "block");
								//$btns.siblings(":visible").css("display", "none");
								
								content.$layout.data("layout").resizeAll();
							}
							
							
						}
					);
				}
			});
			
			/******************************************
			 * Bind action
			 *****************************************/
			// When click into element which doesn't belong header menu,
			//   we will hide menu
			$body.click(function(){
				__.hideSubHeader();
			});
			
			/******************************************
			 * Delete methods or properties is not used more
			 *****************************************/
			delete __.getPersTitle;
			delete __.getViewTitle;
			delete __.getDlgTitle;
		}
		
		,/*
		 * Destroy or unload
		 */
		destroy: function(e){
			// Log out server before leave from browser
			$.ajax({
				dataType: "text"
				,url    : "before_close"
				,cache  : false
				,async  : false
			});
			
			delete cm;
			
			}
	});
})(cm);
	
/***************************************************************************
 * On Ready
 */
$(document).ready(function(){
	/*
	 * Set logout before close browser
	 */
	if($.browser.msie){ // For IE
		window.onbeforeunload = cm.destroy;
	}else{ // For others
		$(window).bind("beforeunload", cm.destroy);
	}
	
	/*
	 * Disable right click
	 */
	$(this).bind("contextmenu", function(e){
		e.preventDefault();
	});
	
	/*
	 * Disable highlight selected text: IE
	 
	if($.browser.msie){
		document.onselectstart = function() { return false; };
		document.unselectable  = "on"; 
	}
	*/
	/*
	 * Prevent action scroll action while you press shift button of document
	 */
	var onMouseWheel = function(e){
		var event = $.event.fix(e);
		if(event.shiftKey){
			if(event.preventDefault){
				event.preventDefault();
			}
		}
	}
	
	if(window.addEventListener){
		// Adding the event onMouseScroll for Mozilla
		document.addEventListener("DOMMouseScroll", onMouseWheel, false);
	}else{
		// Adding the event onMouseScroll for IE/OPERA etc
		document.onmousewheel = function(e){
			if(!e){
				onMouseWheel(window.event);
			}else{
				onMouseWheel(e);
			}
		}
	}
	
	/*
	 * Disable some default action of browser
	 */
	$(window).keypress(function(e){
		var code= e.keyCode || e.charCode || e.which;
		if(code == 27){ // Escape key
			e.preventDefault();
		}
	});
	
	/*
	 * Only enable select for input, textarea, select, option
	 */
	$(document).bind('mousedown selectstart', function(e) {
		return $(e.target).is('input, textarea, select, option'); 
	});
	
	// Initialize ancestor
	cm.init();
});