/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Declare common functions: layout which view use.
 */
$.extend(cm, {
	/***********************************************************************
	 * Facility Tree - Grid: form
	 */
	_fnview_grid: {
		/*
		 * Cache DOM data frequently use
		 */
		setComp: function(){
			var comps = []
			;
			
			// Set function
			comps.push(["grid", "cacheGrid"]);
			return comps;
		}

		,/*
		 * Create layout
		 *    All pans of monitor has a same layout form
		 */
		createLayout: function(){
			var _    = this
			,$layout = _.$layout
			;
			
			$layout.layout({
				center__paneSelector  : ["#", _.getCtnId("grid")].join("")
				,spacing_open         : 2
				,spacing_closed       : 0
				,togglerLength_open   : 0
				,togglerLength_closed : 0
				,enableCursorHotkey   : false
				,showErrorMessages    : false
				,fxSpeed              : 1
				,minSize              : 50
				,center__onresize     : ["resizeInner", _]
				,resizerDblClickToggle: false
			});
		}
		
		,/*
		 * Load monitor data
		 */
		loadData: function(){
			// Load right pane
			this.createGrid();
		}
	}

	,/***********************************************************************
	 * Facility Tree - Grid: form
	 */
	_fnview_tree_grid: {
		/*
		 * Create priority status bar
		 */ 
		setPriorityStatusBar: function(){
			// Declare local variant
			var grid = this.grid
			,pager
			,status_bar
			,content       = new StringBuffer()
			,counter       = 0
			,$sum          =  grid.find("td.priority-cell")
			,createElement = function(type){
				var width = 120 // Unit: pixel
				,index    = counter++
				,quantity = $sum.children(["div.priority-", type].join("")).length
				; 
				
				return [
						"<div class='priority-bar priority-",
							type,
							"' style='width:", width, "px;left: ",
								(index * (width + 1) + 1), "px;'>",
							quantity,
							"</div>"
					].join("");
			}
			;
			
			// Add content of priority bar
			if((pager = grid.$pgr) && (status_bar = pager.find("td:first"))){
				content.append(createElement("critical"));
				content.append(createElement("warning"));
				content.append(createElement("info"));
				content.append(createElement("unknown"));
				
				status_bar.html(content.toString());
			}
		}
		
		,/*
		 * Cache DOM data frequently use
		 */
		setComp: function(){
			var comps = []
			;
			
			// Set function
			comps.push(["tree", "cacheTree"]);
			comps.push(["grid", "cacheGrid"]);
			return comps;
		}
		
		,/*
		 * Create layout
		 *    All pans of monitor has a same layout form
		 */
		createLayout: function(){
			var _    = this
			,$layout = _.$layout
			;
			
			$layout.layout({
				west__paneSelector    : ["#", _.getCtnId("tree")].join("")
				,center__paneSelector : ["#", _.getCtnId("grid")].join("")
				,spacing_open         : 2
				,spacing_closed       : 0
				,togglerLength_open   : 0
				,togglerLength_closed : 0
				,enableCursorHotkey   : false
				,showErrorMessages    : false
				,fxSpeed              : 1
				,west__size           : 0.3
				,minSize              : 50
				,center__onresize     : ["resizeInner", _]
				,resizerDblClickToggle: false
			});
		}
		
		,/*
		 * Load monitor data
		 */
		loadData: function(){
			// Declare local variant
			var _ = this;
			
			// Load tree and grid
			_.createTree();
			_.createGrid();
		}
		
		,/*
		 * Create tree in left pane
		 */
		createTree: function(){
			// Declare local variant
			var _ = this
			,tree = _.tree
			;
			
			// Get tree data
			if((_.getTree) && ((typeof (_.getTree)) == "function")){
				// Set function getData for tree
				/** Bug_29 */
				tree.append($("<div class='tree-loading'></div>"));
				/***********/
				var tree_data = _.getTree();
			}else{
				return;
			}
			
			// Construct the tree layout
			if(tree_data && (tree_data.children)){
				tree.processData({
					onActivate: function(node){
						_.onclickTree(node.data);
					}
				}, tree_data);
				
				tree.controlSize();
			}
		}
	}
	
	,/***********************************************************************
	 * Facility Grid - Grid: form
	 */
	_fnview_grid_grid: {
		/*
		 * Cache DOMs of this layout
		 */
		setComp: function(){
			var comps = []
			;
			
			// Set function
			comps.push(["lgrid", "cacheGrid"]);
			comps.push(["rgrid", "cacheGrid"]);
			return comps;
		}
		
		,/*
		 * Create layout
		 *    
		 */
		createLayout: function(){
			var _    = this
			,$layout = _.$layout
			;
			
			$layout.layout({
				east__paneSelector    : ["#", _.getCtnId("rgrid")].join("")
				,center__paneSelector : ["#", _.getCtnId("lgrid")].join("")
				,spacing_open         : 2
				,spacing_closed       : 0
				,togglerLength_open   : 0
				,togglerLength_closed : 0
				,enableCursorHotkey   : false
				,showErrorMessages    : false
				,fxSpeed              : 1
				,east__size           : 0.5
				,minSize              : 50
				,center__onresize     : ["resizeInner", _]
				,resizerDblClickToggle: false
			});
		}
		
		,/*
		 * Load monitor data
		 */
		loadData: function(){
			// Declare local variant
			var _ = this;
			
			// Load grids
			_.createGrids();
		}
	}
	
	,/***********************************************************************
	 * Facility Tree - Graph: form
	 */
	_fnview_tree_graph: {
		
	}
});