/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Declare functions of perspective
 */
(function(__){
	// Declare common function of perspective,
	//   Inherit from cm.fn, and expand it
	var fnper = $.extend({}, {
		/*******************************************************
		 * Common properties of perspective
		 */
		/*
		 * Get selector of view from its name
		 */
		view2Selr: function(per_id, vw_nm){
			return ["#", per_id, "_", vw_nm].join("");
		}
		
		,/*
		 * Get id of the DOM which contains buttons
		 */
		getBtnId: function(per_id, vw_nm){
			return ["btn_", per_id, "_", vw_nm].join("");
		}
		
		,/*
		 * Get selector of view from its name
		 */
		getViewCtrlFromId: function(vw_id){
			var pos_sep = vw_id.indexOf("_") // Separate position
			;
			
			return [vw_id.substr(0, pos_sep), vw_id.substr(pos_sep + 1)];
				// [perspective name, view name]
		}
		
		,/********************************************************
		 * Tab function properties:
		 */
		/*
		 * Process add view to panel, must be transfer position
		 * @vw_nm: view_name
		 * @per_id : (option)
		 *   * true    : this view is add when perspective is initialized
		 *   * "string": this view belongs another perspective
		 */
		addTab: function(vw_nm, per_id){
			// Cache local variants
			var _ = this   // content of perspective where view was contained
			,$ctn = _.$ctn
			,_id  = _._id // name of perspective where view was declared
			,__act_per         // perspective where view was declared
			,internal
			,view
			,crt_fn   = __.getFnJs(vw_nm)
			,$panel // panel will is used for contain this view
			,per_init = false
			;
			
			/*
			 * Check information
			 */
			// Check status
			if(per_id === true){
				// Perspective is initializing
				per_init = true;
			}
			
			// Check internal view
			if(per_id && (per_id !== true)){
				internal = false; // View of another perspective
				// Is it necessary for checking type of "per_id"
				// "per_id" must be a string
				if(!(__act_per = __[per_id])){
					return;
				}
			}else{
				internal = true; // Perspective add view belong itself
				per_id    = _id;
				__act_per = __[_id];
			}
			
			// Get selector of view
			var selr = _.view2Selr(per_id, vw_nm);
			
			// Check the declaration of this view
			if(!(view = __act_per[vw_nm])){
				return;
			}
			
			// Check view whether to be locked
			if(view._lock){
				// TODO: Check time out id: interval
				return;
			}
			
			// Lock the view is processing
			view._lock = true;
			
			if(view.content){
				var $view = $ctn.find([selr, ":first"].join(""))
				,content  = view.content
				;
				
				// Check whether the view was add to this perspective
				if($view.length){
					// The view was add on this perspective
					$panel = $view.parent();
					
					$panel.tabs("select", selr);
				}else{
					/*
					 * Get panel to contain view
					 */
					if(internal){
						// Get declared position of this view
						var dec_pos = __act_per._views[vw_nm];
						
						// Check validation of dec_pos
						if($.isArray(dec_pos) && (dec_pos.length > 1)){
							// Get panel from id
							$panel = $ctn.find([
								__.panel2Selr(per_id, dec_pos[1], dec_pos[0])
								,":first"
							].join(""));
						}delete dec_pos;
					}
					
					// Check panel whether was found out
					if(!$panel || !($panel.length)){
						// Panel is not set, maybe it was not declared properly or it
						// does not belong this perspective. It will be add to the last
						// panel
						$panel = $ctn.children("div.lay-container:last")
									.children("div.pan-container:last");
					}
					
					$panel.tabs("add", selr, view._title);
					
					// This is not the first view and it is added when clicking
					// header menu, not be added when the perspective loading
					if(($panel.tabs("length") > 1) && !per_init){
						// The first add
						$panel.tabs("select", selr);
					}
				}
				
				view._lock = false;
				// delete $view;
				return;
			}
			
			// Check whether function has been loaded
			if(!(__act_per[crt_fn])){
				// Get function
				$.ajax({
					url      : __.getUrlJs(per_id, vw_nm)
					,cache   : false
					,async   : false
					,dataType: "script"
					,success : function(){
						// Prevent flip, check again
						if(__act_per[crt_fn]){
							return;
						}
						
						// Add constructor function for view
						__act_per[crt_fn] = fn;
						delete fn;
					}
					,error   : __.loadDataError
				});
			}
			
			// Check function
			if(!(__act_per[crt_fn])){
				return;
			}
			
			/*
			 * Get panel to contain view
			 */
			if(internal){
				// Get declared position of this view
				var dec_pos = __act_per._views[vw_nm];
				
				// Check validation of dec_pos
				if($.isArray(dec_pos) && (dec_pos.length > 1)){
					// Get panel from id
					$panel = $ctn.find([
						__.panel2Selr(per_id, dec_pos[1], dec_pos[0])
						,":first"
					].join(""));
				}delete dec_pos;
			}
			
			// Check panel whether was found out
			if(!$panel || !($panel.length)){
				// Panel is not set, maybe it was not declared properly or it
				// does not belong this perspective. It will be add to the last
				// panel
				$panel = $ctn.children("div.lay-container:last")
							.children("div.pan-container:last");
			}
			
			/*
			 * Add view
			 */
			// Check whether we will add the first tab
			if($panel.tabs("length") === 0){
				view._init = true;
			}else{
				view._init = false;
			}
			
			// Store name of perspective which currently contain this view
			view._belong = _id;
			
			// Add a new tab
			$panel.tabs("add", selr, view._title);
			
			// Get HTML of view from server
			$.ajax({
				url      : __.getCompLayUrl(per_id, vw_nm)
				,cache   : false
				,dataType: "html"
				,type    : "get"
				,success : function(data_respond){
					// Set html data
					var f_ctn = $panel.children(selr)
					,f_layout = f_ctn.children("div") // Add layout: only a div
					,vw_id    = selr.slice(1) // not get "#"
					,$_data   = $(data_respond)
					,f_btns   = $_data.children("div.view-btns-container:first")
					,f_body   = $_data.children("#body")
					;
					
					// Buttons
					// Body
					// Buttons
					// Add class for body and layout
					f_body.children().addClass("elem-container");
					f_layout.addClass("layout-view-container");
					
					// Add id for button
					f_btns.attr("id", _.getBtnId(per_id, vw_nm));
					
					f_layout.html(f_body.html());
					$panel.find(".ins-right-tab:first").append(f_btns);
					delete $_data;
					
					// Declare and initialize content
					var content = $.extend(
						{}
						,__._fnview
						,{
							_id     : vw_id    // Set reference
							,$ctn   : f_ctn    // Set container
							,$btns  : f_btns
							,$layout: f_layout
						}
					);
					
					// Add private configuration of views
					$.extend(content, __act_per[crt_fn](view));
					
					// Assign content to view
					view.content = content;
					
					// Initialize create view
					if(view._init){
						content.init();
					}else{
						// Select panel when it was added from menu
						if(!internal){
							$panel.tabs("select", selr);
						}else{
							// Set none display for button DIV
							f_btns.css("display", "none");
						}
					}
					
					// End process: Unlock for view
					view._lock = false;
				}
				,error   : __.loadDataError
			});
		}
		
		/********************************************************
		 * View functions
		 */
		,/*
		 * Add a view
		 */
		addView: function(vw_nm){ // view name
			var _ = this
			,name = _.name
			,arr // Array content of string split
			,len // Length of array
			;
			
			arr = vw_nm.split(".");
			len = arr.length;
			
			if(arr[0] == name){
				// The view belong this perspective
				_.addTab(arr[1]);
			}else{
				_.addTab(arr[1], arr[0]);
			}
		}
		
		/********************************************************
		 * Main actions
		 */
		,/*
		 * Initializes perspective
		 */
		init: function(){
			// Cache local variants
			var _ = this 
			,_id  = _._id  // Elements which was constructed
			,$ctn = _.$ctn // for this perspective
			,d_layout  // The layout was declared
			
			// Template of layout container
			,lay_ctn_tplt = "<div class='lay-container' id='#{id}'/>"
			
			// Template of panel container
			,pan_ctn_tplt = "<div class='pan-container' id='#{id}'><ul class='header-panel'><ins class='ins-right-tab'></ins></ul></div>"
			
			// Process for constructing a tab panel
			,createPanel  = function(p_pan){
				// Tab options
				p_pan.tabs({
					tabTemplate   : [
							"<li><a href='#{href}'>"
							,__.getIconStr("ui-icon-hnm-tab")
							,"#{label}</a></span></li>"
						].join("")
					,panelTemplate: "<div class='view-container'><div>"
					,select       : function(event, ui){
						__.hideDefaultNoneDisplay();
					}
					,show         : function(event, ui){
						var $pan = ui.jquery ? ui : $(ui.panel)
						,vw_id   = $pan.attr("id")
						,vw_ctrl = _.getViewCtrlFromId(vw_id)
						,view    = __[vw_ctrl[0]][vw_ctrl[1]]
						,content
						,$layout
						,layout
						;
						
						// Property 'display' is set into 'none' when layout resize
						if($pan.css("display") != "block"){
							$pan.css("display", "block");
						}
						
						/* 
						 * Check for moving DOM: buttons and content
						 */
						if(content = view.content){
							var $btns = content.$btns;
							if(view._belong != _id){
								// Renew _belong
								view._belong = _id;
								$layout      = content.$layout;
								
								// Move content of view
								$pan.html($layout.detach());
								
								// Move buttons
								$btns.detach().appendTo($pan
									.siblings("ul.header-panel:first")
										.children(".ins-right-tab:first"));
								
								// Set container again
								content.$ctn = $pan;
							}
							
							// Show buttons of this tabs and set no display for others' buttons
							$btns.css("display", "block");
							$btns.siblings(":visible").css("display", "none");
						}
						
						// Check whether the view initialized:
						if(!(view._init)){
							// Content was created but has not initialized yet
							view._init = true;
							view.content.init();
						}else{
							// Resize layout
							if(content && ($layout = content.$layout)
									&& (layout = $layout.data("layout"))
									&& (layout.resizeAll)){
								layout.resizeAll();
							}
						}
					}
				});
			}
			;
			
			/*************************************
			 * Main layout
			 */
			// Check and Get configuration of layouts
			if(!((d_layout = __[_id]._layout) && $.isArray(d_layout) && (d_layout.length))){
				// Layout is not declared
				
				return;
			}
			
			// Construct main layout
			var _lays = []
			,lay_len  = d_layout.length; // Main layout length
			
			for(var lay_cnt = 0; lay_cnt < lay_len; lay_cnt++){ // counter
				// Set template for layout
				_lays[lay_cnt] = $(lay_ctn_tplt.replace(/#\{id\}/, __.layout2Selr(_id, lay_cnt).slice(1)));
			
				// Append layout to perspective
				$ctn.append(_lays[lay_cnt]);
			}
			
			// Run layout
			$ctn.layout($.extend({}, d_layout.option, {
				autoResize            : true
				,autoReopen           : true
				,autoBindCustomButtons: true
				,resizerDblClickToggle: false
				,togglerLength_open   : 0
				,spacing_closed       : 0
				,spacing_open         : 2
				,enableCursorHotkey   : false
				,showErrorMessages    : false
				,minSize              : 30
				,center__minHeight    : 30
			}));
			
			/*************************************
			 * Element layouts: panels
			 */
			for(var lay_cnt = 0; lay_cnt < lay_len; lay_cnt++){ // main layout counter
				// Initialize the cnt_lay_th pane
				var $lay = _lays[lay_cnt]
				,lay_opt = d_layout[lay_cnt]      // Get option
				,pn_len  = d_layout.lens[lay_cnt] // Get length
				;
				
				// Create DOME for panel element
				for(var pn_cnt = 0; pn_cnt < pn_len; pn_cnt++){
					var $panel = $(pan_ctn_tplt.replace(/#\{id\}/
							,__.panel2Selr(_id, pn_cnt, lay_cnt).slice(1)
					));
					
					// Create tab panel
					createPanel($panel)
					
					// Append panel to element layout
					$lay.append($panel);
				}
				
				// Create layout
				$lay.layout($.extend(
					{}
					,lay_opt
					,{
						autoResize            : true
						,autoReopen           : true
						,autoBindCustomButtons: true
						,resizerDblClickToggle: false
						,togglerLength_open   : 0
						,spacing_closed       : 0
						,spacing_open         : 2
						,enableCursorHotkey   : false
						,showErrorMessages    : false
						,minSize              : 30
						,center__minHeight    : 30
						,onresize             : function(pane, $ps_pane){
							var $layout = $ps_pane.
								children("div.view-container:visible").
										children(":first")
							,layout     = $layout.data("layout")
							;
							
							if(layout && (layout.resizeAll)){
								layout.resizeAll();
							}
						}
					}
				));
			}
			
			/*************************************
			 * Add view to panel
			 */
			var views;
			if(views = __[_id]._views){
				for(var vw_nm in views){
					// TODO: check create view result, set call back???
					_.addTab(vw_nm, true);
				}
			}
			
		}
	});
	
	// Add fnpers to common
	__._fnper = fnper;
})(cm);