/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Common dialogs
 */
(function(__){
	// Prompt variants
	var PROMPT_LEVEL_DFT = __.LEVEL_ERROR
	var Exist_Dialogs = false
	,prompt_icon_list = [
		"icon-ok"
		,"icon-info"
		,"icon-warning"
		,"icon-error"
	]
	,prompt_title_list = [
		__.getLang("ok_o")
		,__.getLang("message")
		,__.getLang("warning")
		,__.getLang("failed")
	]
	
	;
	
	// Declare function for open dialogs
	$.extend(__, {
		/*
		 * Use for dialog only add text content
		 * *
		 * Parameter:
		 *   dlg: object content:
		 *     title
		 *     content
		 */
		openTextDlg: function(dlg){
			var $dlg = $([
				"<div class='dlg-container'><div class='dlg-cnt-div'>"
				,dlg.content
				,"</div></div>"
			].join(""));
			
			$dlg.appendTo("body");
			
			$dlg.dialog({
				resizable: true
				,title   : __.getIconStrTitle(dlg.title)
				,modal   : true
				,autoOpen: true
				,width   : 350
				,height  : 180
				,close   : function(){
					// remove dialog
					$(this).dialog("destroy");
					$dlg.remove();
					delete $dlg;
				}
				,buttons: [
					{
						text  : __.getLang("cancel")
						,click: function(){
							$(this).dialog("close");
						}
					}
				]
			});
		}
		
		,/*
		 * Use for view with filter is a date
		 * *
		 * Parameter:
		 *   grid    : the grid will be refresh.
		 *   callback: function will execute when 'OK'
		 */
		openCalendar: function(obj, callback){
			var $dlg   = $("<div id='dialog-calendar'><center><div id='datepicker'></div></center></div>")
			,$date_pkr = $dlg.find("#datepicker:first");
			;
			
			// Append dialog
			$dlg.appendTo("body");
			
			// Create dialog
			$dlg.dialog({
				resizable: false
				,title   : __.getIconStrTitle(__.getLang("calendar"))
				,dialogClass: "ui-dialog-calendar"
				,width   : 230
				,height  : 260
				,position: ["center", 115]
				,modal   : true
				,close   : function(){
					// remove dialog
					$(this).dialog("destroy");
					$dlg.remove();
					delete $dlg;
				}
				,buttons : [{
					text  : __.getLang("ok_o")
					,click: function() {
						var date = $date_pkr.datepicker("getDate")
						,y=date.getFullYear()
						,m=date.getMonth()
						,d=date.getDate()
						,now = new Date() // getToday
						;
						
						var value = new Date(y, m, d, now.getHours(),
									now.getMinutes(), now.getSeconds(), 
													now.getMilliseconds());
						callback.call(obj, value.getTime());
						
						$(this).dialog("close");
					}
				}
				,{
					text  : __.getLang("cancel")
					,click: function() {
						$( this ).dialog( "close" );
					}
				}]
			});
			
			$date_pkr.datepicker($.extend({}
				,__.getLang("datepicker")
				,{
					showOtherMonths   : true
					,selectOtherMonths: true
					,changeMonth      : true
					,changeYear       : true
					,gotoCurrent      : true
				}
			));
			
			return false;
		}
		
		,/*
		 * Use get a value of tree
		 *   This dialog apply for JOB_TREE and FACILTIY_TREE
		 * *
		 * Parameter:
		 *   tree: object content 4 properties
		 *     - title: title of dialog
		 *     - data : tree data
		 *     - input: input which value is set
		 *     - key  : property which you want get value of
		 *     - checkValue: check valid of data
		 *     - showInform: showInform of checking fail
		 */
		openTreeDlg: function(tree){
			var $dlg   = $([
				"<div class='dlg-container'></div>"
			].join(""))
			,$tree     = $("<div class='dlg-cnt-div'></div>")
			,tree_data = $.extend({}, tree.data, {activate: true, expand: true})
			,excecute  = function(active_node){
				var node_data
				,data_key
				;
				
				if(active_node && (node_data = active_node.data)){
					if((data_key = node_data[tree.key]) !== undefined){
						tree.input.val(data_key)
					}}}
			;
			
			// Append to HTML document
			$tree.appendTo($dlg);
			$dlg.appendTo("body");
			
			// Construct for dialog
			$dlg.dialog({
				resizable: true
				,title   : __.getIconStrTitle(tree.title)
				,modal   : true
				,autoOpen: true
				,width   : 250
				,height  : 180
				,close   : function(){
					// remove dialog
					$(this).dialog("destroy");
					$dlg.remove();
					delete $tree;
					delete $dlg;
				}
				,buttons: [
					{
						text  : __.getLang("ok_o")
						,click: function(){
							var value = $tree.dynatree("getActiveNode")
							,check    = true
							;
							
							if(tree.checkValue
									&& ((typeof tree.checkValue) == "function")){
								check = tree.checkValue(value);
							}
							
							// Check variant "check"
							if(check){
								excecute(value);
								$(this).dialog("close");
							}else{
								if(tree.showInform
										&& ((typeof tree.showInform) == "function")){
									tree.showInform();
								}
							}
						}
					}
					,{
						text  : __.getLang("cancel")
						,click: function(){
							$(this).dialog("close");
						}
					}
				]
			});
			
			// Construct for tree
			$tree.dynatree({
				clickFolderMode: 1
				,children      : tree_data
				,onDblClick    : function(value){
					var check = true;
					
					if(tree.checkValue
							&& ((typeof tree.checkValue) == "function")){
						check = tree.checkValue(value);
					}
					
					// Check variant "check"
					if(check){
						excecute(value);
						$dlg.dialog("close");
					}else{
						if(tree.showInform
								&& ((typeof tree.showInform) == "function")){
							tree.showInform();
						}
					}
				}
			});
		}
		
		,/*
		 * Confirm a action of user
		 * *
		 * Parameter:
		 *   dlg: object content:
		 *     title  : title of dialog
		 *     content: content of notice
		 *   cb: callback function
		 *   obj: object of calling "callback", if null, cm object is taken
		 */
		openConfirmDlg: function(dlg, cb, obj){
			var icon_class = "icon-confirm"
			,$dlg = $([
				"<div class='dlg-container'><div class='dlg-inform-content'><span class='icon-prompt "
				,icon_class
				,"'></span><span class='inform-content'>"
				,dlg.content
				,"</span></div></div>"
			].join(""))
			;
			
			$dlg.appendTo("body");
			
			$dlg.dialog({
				resizable: false
				,title   : __.getIconStrTitle(dlg.title)
				,modal   : true
				,autoOpen: true
				,width   : 600
				,height  : 150
				,position: ["center", 125]
				,close   : function(){
					// Remove dialog
					$(this).dialog("destroy");
					$dlg.remove();
					delete $dlg;
				}
				,buttons: [
					{
						text  : __.getLang("yes")
						,click: function(){
							if(obj){
								cb.call(obj);
							}else{
								cb.call(cm);
							}
							$(this).dialog("close");
						}
					}
					,{
						text  : __.getLang("no")
						,click: function(){
							$(this).dialog("close");
						}
					}
				]
			});
		}
		
		,/*
		 * Display message to notice to user
		 * *
		 * Parameter:
		 *   dlg: object content:
		 *     message: string or object
		 *     level  : number
		 */
		openPromptDlg: function(dlg){
			if(Exist_Dialogs == true)
			{
				return;
			}
			Exist_Dialogs = true;
			var msg
			,level
			,icon_class
			,title
			,content
			;
			
			// Check type of level
			if(((level = dlg.level) === undefined)
				|| ((typeof level) != "number")
				|| !(prompt_icon_list[level])){
				level = PROMPT_LEVEL_DFT;
			}
			
			// Set icon and title
			icon_class = prompt_icon_list[level];
			
			// Set content
			if(msg = dlg.message){
				if((typeof msg) == "string"){
					content = msg;
				}else if((typeof msg) == "object"){
					if(msg.content){
						content = msg.content;
					}
					
					if(msg.title){
						title = msg.title;
					}
				}
			}
			
			// Check title
			if(!(title || ((typeof title) == "string"))){
				title = prompt_title_list[level];
			}
			
			// check content
			if(!(content || ((typeof content) == "string"))){
				content = __.getLang("error_connection");
			}
			
			/** Bug_08 */
			if ((content == __.getLang("error_timeout")) || (content == __.getLang("error_connection"))){
				var time = $.fn.fmatter.hnmDatetime(new Date().getTime(), 'Y-m-d h:m:s.u');
				content = content + "(" + time + ")";
			}
			/***********/
			// Construct template of dialog
			var $dlg = $([
				"<div class='dlg-container'><div class='dlg-inform-content'><span class='icon-prompt "
				,icon_class
				,"'></span><span class='inform-content'>"
				,content
				,"</span></div></div>"
			].join(""));
			
			// Append DOM dialog to body
			$dlg.appendTo("body");
			
			// Construct dialog
			$dlg.dialog({
				resizable: false
				,title   : __.getIconStrTitle(title)
				,modal   : true
				,autoOpen: true
				,width   : 600
				,height  : 150
				,position: ["center", 125]
				,close   : function(){
					// Remove dialog
					$(this).dialog("destroy");
					$dlg.remove();
					delete $dlg;
					
					// Check level
					if(level === __.LEVEL_ERROR){
						__.logout();
					}
				}
				,buttons: [
					{
						text  : __.getLang("ok_o")
						,click: function(){
							$(this).dialog("close");
						}
					}
				]
			});
		}
	});
})(cm);