/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * Home servlet
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class LayoutServlet extends CommonServlet {
    private static final long serialVersionUID = -1716698198316681308L;

    private static final String JSP_FOLDER = "/jsp";

    private static final String JSP_EXTENSION = ".jsp";

    private static final String JSP_ERROR_404 = "/error404.jsp";

    private static LogUtils logUtils = LogUtils
            .getLogUtils(LayoutServlet.class);

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.necsoft.hinemos.webclient.servlet.CommonServlet#process(javax.servlet
     * .http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    public CommonJson process(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        try {
            doForwardToLayout(request, response);
        } catch (Exception ex) {
            logUtils.error("exception.common.layout.forward", ex.getCause());
        }
        return null;
    }

    private void doForwardToLayout(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebException {
        // Get the remain path after Servlet_Path
        String extraPath = getExtraPath(request);
        if (extraPath.equals("")) {
            getServletContext()
                    .getRequestDispatcher(JSP_FOLDER + JSP_ERROR_404).forward(
                            request, response);
        } else {
            getServletContext().getRequestDispatcher(
                    JSP_FOLDER + extraPath + JSP_EXTENSION).forward(request,
                    response);
        }
    }
}
