/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/



package com.necsoft.hinemos.webclient.repository.json;

import java.util.ArrayList;
import java.util.Map;

import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.repository.bean.FacilityTreeBean;

/**
 * Template for generator FacilityTree JSON
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityTreeJson extends CommonJson {
    private ArrayList<FacilityTreeBean> facilityTree;

    private Map<String, Integer> typeList;
    private Map<String, String> reservedList;

    public FacilityTreeJson() {
        this.facilityTree = new ArrayList<FacilityTreeBean>();
    }

    // Add a FacilityTreeBean to list
    public void addFacilityTree(FacilityTreeBean facilityTree) {
        this.facilityTree.add(facilityTree);
    }

    /**
     * @return the facilityTree
     */
    public ArrayList<FacilityTreeBean> getFacilityTree() {
        return facilityTree;
    }

    /**
     * @param facilityTree
     *            the facilityTree to set
     */
    public void setFacilityTree(ArrayList<FacilityTreeBean> facilityTree) {
        this.facilityTree = facilityTree;
    }

    public Map<String, Integer> getTypeList() {
        return typeList;
    }

    public void setTypeList(Map<String, Integer> typeList) {
        this.typeList = typeList;
    }

    public Map<String, String> getReservedList() {
        return reservedList;
    }

    public void setReservedList(Map<String, String> reservedList) {
        this.reservedList = reservedList;
    }

}