/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/



package com.necsoft.hinemos.webclient.repository.business;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.necsoft.hinemos.webclient.bean.PropertyValue;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.repository.RepositoryConstants;
import com.necsoft.hinemos.webclient.repository.action.GetNodeProperty;
import com.necsoft.hinemos.webclient.repository.form.NodePropertyForm;

/**
 * This class used for get NodeProperty
 * 
 * @version 1.0
 * @date 2012/1/14
 */
public class GetNodePropertyBusiness {

    public GridDataJson getNodeProperty(NodePropertyForm form,
            NamingContext namingContext, Locale locale)
            throws HinemosWebException {

        GetNodeProperty nodeProperty = null;
        Property propertyNode = null;
        GridDataJson result = null;

        nodeProperty = new GetNodeProperty();
        nodeProperty.setNamingContext(namingContext);
        propertyNode = nodeProperty.getProperty(
                StringEscapeUtils.unescapeHtml(form.getFacilityId()),
                PropertyConstant.MODE_SHOW, locale);
        // Convert to json
        result = doConvertToJson(propertyNode.getChildren());

        return result;
    }

    public GridDataJson doConvertToJson(Object[] listInfoData) {
        // Create JSON
        GridDataJson result = new GridDataJson();
        generateSerializedData(result, listInfoData,
                JsConstant.TREEGRID_ROOT_LEVEL,
                JsConstant.TREEGRID_ROOT_PARENT, "");
        return result;
    }

    private void generateSerializedData(GridDataJson result, Object[] listItem,
            int level, String parentId, String sub) {

        boolean isLeaf;

        for (int count = 0; count < listItem.length; count++) {
            Property item = (Property) listItem[count];
            if (item.getChildren().length != 0) {
                isLeaf = false;
            } else {
                isLeaf = true;
            }

            // Add data
            result.addRow(doConvertPropertyToArray(item, level, parentId,
                    isLeaf, sub));

            // Generate children data
            if (!isLeaf) {
                String more_sub = RepositoryConstants.getIdOfPropertyMulti(
                        item.getID(), item.getChildren());
                generateSerializedData(result, item.getChildren(), level + 1,
                        item.getID() + more_sub, more_sub);
            }
        }
    }

    private ArrayList<Object> doConvertPropertyToArray(Property prop,
            int level, String parentId, boolean isLeaf, String sub) {

        // Create JSON
        ArrayList<Object> result = new ArrayList<Object>();
        String id = prop.getID();
        String id_sub = id + sub;
        PropertyValue objValue = new PropertyValue();
        String editor;
        Object value;
        String type;
        Map<String, Object> option = null;

        // Get value of expanded
        boolean expanded = false;
        if ((!isLeaf) && (level == JsConstant.TREEGRID_ROOT_LEVEL)) {
            if (RepositoryConstants.isMultiProperty(id)) {
                id_sub += RepositoryConstants.getIdOfPropertyMulti(id,
                        prop.getChildren());
            } else {
                expanded = true;
            }
        }

        // Set object value
        editor = prop.getEditor();
        value = prop.getValue();

        // Check null for editor
        if (editor == null) {
            editor = PropertyConstant.EDITOR_TEXT;
        }

        if (editor.equals(PropertyConstant.EDITOR_BOOL)) {
            type = JsConstant.PROPERTY_TYPE_BOOL;
            option = new HashMap<String, Object>();
            option.put("disabled", true);
        } else if (editor.equals(PropertyConstant.EDITOR_TEXTAREA)) {
            type = JsConstant.PROPERTY_TYPE_TEXTAREA;
            value = StringEscapeUtils.escapeHtml(value.toString());
        } else if (editor.equals(PropertyConstant.EDITOR_DATETIME)) {
            type = JsConstant.PROPERTY_TYPE_DATETIME;
            if (value != null) {
                value = ((Date) value).getTime();
            }
        } else {
            type = JsConstant.PROPERTY_TYPE_TEXT;
            value = StringEscapeUtils.escapeHtml(value.toString());
        }

        // Set object
        objValue.setType(type);
        objValue.setValue(value);
        if (option != null) {
            objValue.setOption(option);
        }

        // Construct result
        result.add(id_sub);
        result.add(prop.getName());
        result.add(objValue);

        // Add properties for tree grid
        result.add(level);
        result.add(parentId);
        result.add(isLeaf);
        result.add(expanded);
        result.add(JsConstant.TREE_LOADED);

        return result;
    }
}
