/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.repository.bean.ScopeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.repository.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.repository.util.EjbConnectionManager;

/**
 * 登録スコープ一覧を取得するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetScopeList {

    // ----- instance メソッド ----- //
    // namingContextを定義
    private NamingContext m_namingContext = null;

    /**
     * namingContextを設定
     * 
     * @param namingContext
     * @return void
     */
    public void setNamingContext(NamingContext namingContext) {
        this.m_namingContext = namingContext;
    }

    /**
     * 登録スコープ一覧を取得します。
     * 
     * @param facilityId
     *            ファシリティID
     * @return 登録スコープ一覧
     * @throws HinemosWebException
     */
    public ArrayList<ArrayList> getScopeList(String facilityId)
            throws HinemosWebException {
        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        RepositoryController repository = ejbConnectionManager
                .getRepositoryController();

        ArrayList<ScopeInfo> records = null;
        try {
            records = repository.getScopeList(facilityId);
        } catch (AccessException e) {
            throw new HinemosWebAccessException(
                    "exception.repository.scope.access", e);
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException(
                    "exception.repository.scope.remote", e);
        }
        if (records == null) {
            throw new HinemosWebException("message.force.disconnect");
        }
        ArrayList<ArrayList> list = ConvertListUtil
                .convertScopeInfoListToArrayList(records);
        return list;
    }
}