/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.repository;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.bean.NodeConstant;

public class RepositoryConstants {
    private static final String SEPARATOR = "_";

    private static final Map<String, String> MAP_PROPERTY_MULTI = new HashMap<String, String>();
    static {
        MAP_PROPERTY_MULTI.put(NodeConstant.VIRTUALIZATION,
                NodeConstant.VMINDEX);
        MAP_PROPERTY_MULTI.put(NodeConstant.DEVICE, NodeConstant.DEVICE_INDEX);
        MAP_PROPERTY_MULTI.put(NodeConstant.FILE_SYSTEM,
                NodeConstant.FILE_SYSTEM_INDEX);
    }

    public static final int NODE_LIST_TABLE_HEADER_NUM = 3;

    public static final int NODE_SCOPE_TABLE_HEADER_NUM = 1;

    public static final int SCOPE_LIST_TABLE_HEADER_NUM = 3;

    /**
     * @param id
     * @return
     */
    public static boolean isMultiProperty(String id) {
        return MAP_PROPERTY_MULTI.containsKey(id);
    }

    /**
     * @param id
     * @param children
     * @return
     */
    public static String getIdOfPropertyMulti(String id, Object[] children) {
        String sub = "";
        String indexKey;
        if ((id == null) || !isMultiProperty(id)) {
            return "";
        }

        indexKey = MAP_PROPERTY_MULTI.get(id);

        if ((children != null) && (children.length != 0)) {
            for (int count = 0; count < children.length; count++) {
                Property item = (Property) children[count];
                if ((item.getID() != null) && item.getID().equals(indexKey)) {
                    if ((item.getValue() != null) && !item.getValue().equals("")) {
                        sub = SEPARATOR
                                + StringEscapeUtils.escapeHtml(item.getValue()
                                        .toString());
                    }
                    break;
                }
            }
        }

        return sub;
    }

}
