/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringEscapeUtils;

import com.clustercontrol.monitor.bean.EventTableDefine;
import com.clustercontrol.monitor.bean.ScopeInfoData;
import com.clustercontrol.monitor.bean.ScopeTableDefine;
import com.clustercontrol.monitor.bean.StatusInfoData;
import com.clustercontrol.monitor.bean.StatusTableDefine;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogData;

/**
 * 表示用のリストに変換するクラス
 **/
public class ConvertListUtil {

    /********************************************************************
     * Scope
     */
    /**
     * @param list
     * @return
     */
    public static ArrayList<ArrayList<Object>> scopeInfoDataListToArrayList(
            ArrayList<ScopeInfoData> list) {

        ArrayList<ArrayList<Object>> ret = new ArrayList<ArrayList<Object>>();
        Iterator<ScopeInfoData> itr = list.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> status = new ArrayList<Object>();
            ScopeInfoData scopeInfoData = itr.next();

            status.add(ScopeTableDefine.PRIORITY, scopeInfoData.getPriority());

            status.add(ScopeTableDefine.FACILITY_ID,
                    scopeInfoData.getFacilityId());

            status.add(ScopeTableDefine.SCOPE, scopeInfoData.getFacilityPath());

            Long updateTime = null;
            if (scopeInfoData.getOutputDate() != null) {
                updateTime = scopeInfoData.getOutputDate().getTime();
            }
            status.add(ScopeTableDefine.UPDATE_TIME, updateTime);

            status.add(ScopeTableDefine.SORT_VALUE,
                    scopeInfoData.getSortValue());

            ret.add(status);
        }

        return ret;
    }

    /**
     * @param list
     */
    public static void sanitizeScopeInfoData(ArrayList<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            ArrayList<Object> row = list.get(count);

            if (row.get(ScopeTableDefine.FACILITY_ID) != null) {
                row.set(ScopeTableDefine.FACILITY_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                ScopeTableDefine.FACILITY_ID).toString()));
            }

            if (row.get(ScopeTableDefine.SCOPE) != null) {
                row.set(ScopeTableDefine.SCOPE,
                        StringEscapeUtils.escapeHtml(row.get(
                                ScopeTableDefine.SCOPE).toString()));
            }
        }
    }

    /********************************************************************
     * Status
     */
    public static ArrayList<ArrayList<Object>> statusInfoDataListToArrayList(
            ArrayList<StatusInfoData> list) {

        ArrayList<ArrayList<Object>> ret = new ArrayList<ArrayList<Object>>();
        Iterator<StatusInfoData> itr = list.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> status = new ArrayList<Object>();
            StatusInfoData statusInfoData = itr.next();

            status.add(StatusTableDefine.PRIORITY, statusInfoData.getPriority());

            status.add(StatusTableDefine.PLUGIN_ID,
                    statusInfoData.getPluginId());

            status.add(StatusTableDefine.MONITOR_ID,
                    statusInfoData.getMonitorId());

            status.add(StatusTableDefine.FACILITY_ID,
                    statusInfoData.getFacilityId());

            status.add(StatusTableDefine.SCOPE,
                    statusInfoData.getFacilityPath());

            status.add(StatusTableDefine.APPLICATION,
                    statusInfoData.getApplication());

            Long updateTime = null;
            if (statusInfoData.getOutputDate() != null) {
                updateTime = statusInfoData.getOutputDate().getTime();
            }
            status.add(StatusTableDefine.UPDATE_TIME, updateTime);

            Long outputTime = null;
            if (statusInfoData.getGenerationDate() != null) {
                outputTime = statusInfoData.getGenerationDate().getTime();
            }
            status.add(StatusTableDefine.OUTPUT_TIME, outputTime);

            status.add(StatusTableDefine.MESSAGE_ID,
                    statusInfoData.getMessageId());

            status.add(StatusTableDefine.MESSAGE, statusInfoData.getMessage());

            ret.add(status);
        }

        return ret;

    }

    /**
     * @param list
     */
    public static void sanitizeStatusInfoData(ArrayList<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            ArrayList<Object> row = list.get(count);
            if (row.get(StatusTableDefine.PLUGIN_ID) != null) {
                row.set(StatusTableDefine.PLUGIN_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                StatusTableDefine.PLUGIN_ID).toString()));
            }

            if (row.get(StatusTableDefine.MONITOR_ID) != null) {
                row.set(StatusTableDefine.MONITOR_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                StatusTableDefine.MONITOR_ID).toString()));
            }

            if (row.get(StatusTableDefine.FACILITY_ID) != null) {
                row.set(StatusTableDefine.FACILITY_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                StatusTableDefine.FACILITY_ID).toString()));
            }

            if (row.get(StatusTableDefine.SCOPE) != null) {
                row.set(StatusTableDefine.SCOPE,
                        StringEscapeUtils.escapeHtml(row.get(
                                StatusTableDefine.SCOPE).toString()));
            }

            if (row.get(StatusTableDefine.APPLICATION) != null) {
                row.set(StatusTableDefine.APPLICATION,
                        StringEscapeUtils.escapeHtml(row.get(
                                StatusTableDefine.APPLICATION).toString()));
            }

            if (row.get(StatusTableDefine.MESSAGE_ID) != null) {
                row.set(StatusTableDefine.MESSAGE_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                StatusTableDefine.MESSAGE_ID).toString()));
            }

            if (row.get(StatusTableDefine.MESSAGE) != null) {
                row.set(StatusTableDefine.MESSAGE,
                        StringEscapeUtils.escapeHtml(row.get(
                                StatusTableDefine.MESSAGE).toString()));
            }
        }
    }

    /********************************************************************
     * Event
     */
    /**
     * 
     * SessionBean経由で取得されたEventLogDataのリストを、
     * 表示用のリスト（ArrayListの二次元配列）に変換するためのメソッドです。
     * 
     * @param list
     * @return
     */
    public static ArrayList<ArrayList<Object>> eventLogDataListToArrayList(
            ArrayList<EventLogData> list) {

        ArrayList<ArrayList<Object>> ret = new ArrayList<ArrayList<Object>>();
        Iterator<EventLogData> itr = list.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> event = new ArrayList<Object>();
            EventLogData eventLogData = itr.next();

            event.add(EventTableDefine.PRIORITY, eventLogData.getPriority());

            Long receiveTime = null;
            if (eventLogData.getOutputDate() != null) {
                receiveTime = eventLogData.getOutputDate().getTime();
            }
            event.add(EventTableDefine.RECEIVE_TIME, receiveTime);

            Long outputData = null;
            if (eventLogData.getGenerationDate() != null) {
                outputData = eventLogData.getGenerationDate().getTime();
            }
            event.add(EventTableDefine.OUTPUT_DATE, outputData);

            event.add(EventTableDefine.PLUGIN_ID, eventLogData.getPluginId());

            event.add(EventTableDefine.MONITOR_ID, eventLogData.getMonitorId());

            event.add(EventTableDefine.FACILITY_ID,
                    eventLogData.getFacilityId());

            event.add(EventTableDefine.SCOPE, eventLogData.getScopeText());

            event.add(EventTableDefine.APPLICATION,
                    eventLogData.getApplication());

            event.add(EventTableDefine.MESSAGE_ID, eventLogData.getMessageId());

            event.add(EventTableDefine.MESSAGE, eventLogData.getMessage());

            event.add(EventTableDefine.CONFIRMED, eventLogData.getConfirmFlg());

            event.add(EventTableDefine.CONFIRM_USER,
                    eventLogData.getConfirmUser());

            ret.add(event);
        }

        return ret;
    }

    /**
     * @param list
     */
    public static void sanitizeEventLogData(ArrayList<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            ArrayList<Object> row = list.get(count);

            if (row.get(EventTableDefine.PLUGIN_ID) != null) {
                row.set(EventTableDefine.PLUGIN_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                EventTableDefine.PLUGIN_ID).toString()));
            }

            if (row.get(EventTableDefine.MONITOR_ID) != null) {
                row.set(EventTableDefine.MONITOR_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                EventTableDefine.MONITOR_ID).toString()));
            }

            if (row.get(EventTableDefine.FACILITY_ID) != null) {
                row.set(EventTableDefine.FACILITY_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                EventTableDefine.FACILITY_ID).toString()));
            }

            if (row.get(EventTableDefine.SCOPE) != null) {
                row.set(EventTableDefine.SCOPE,
                        StringEscapeUtils.escapeHtml(row.get(
                                EventTableDefine.SCOPE).toString()));
            }

            if (row.get(EventTableDefine.APPLICATION) != null) {
                row.set(EventTableDefine.APPLICATION,
                        StringEscapeUtils.escapeHtml(row.get(
                                EventTableDefine.APPLICATION).toString()));
            }

            if (row.get(EventTableDefine.MESSAGE_ID) != null) {
                row.set(EventTableDefine.MESSAGE_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                EventTableDefine.MESSAGE_ID).toString()));
            }

            if (row.get(EventTableDefine.MESSAGE) != null) {
                row.set(EventTableDefine.MESSAGE,
                        StringEscapeUtils.escapeHtml(row.get(
                                EventTableDefine.MESSAGE).toString()));
            }
        }
    }

    /**
     * 
     * 監視[イベント]ビューに表示される内容を基にして、 EventLogDataのリストに変換するためのメソッドです。
     * 
     * オリジナルメッセージのように、表示されていない項目については、 セットされないので注意してください。
     * 
     * @param list
     * @return
     */
    public static ArrayList<EventLogData> listToEventLogDataList(List<?> list) {

        ArrayList<EventLogData> eventLogDataList = new ArrayList<EventLogData>();
        Iterator<?> itr = list.iterator();
        while (itr.hasNext()) {

            ArrayList<?> event = (ArrayList<?>) itr.next();

            Integer priority = Integer.valueOf((String) event
                    .get(EventTableDefine.PRIORITY));
            Timestamp outputDate = new Timestamp(
                    ((Date) event.get(EventTableDefine.RECEIVE_TIME)).getTime());
            Timestamp generationDate = new Timestamp(
                    ((Date) event.get(EventTableDefine.OUTPUT_DATE)).getTime());
            String pluginId = (String) event.get(EventTableDefine.PLUGIN_ID);
            String monitorId = (String) event.get(EventTableDefine.MONITOR_ID);
            String facilityId = (String) event
                    .get(EventTableDefine.FACILITY_ID);
            String scopeText = (String) event.get(EventTableDefine.SCOPE);
            String application = (String) event
                    .get(EventTableDefine.APPLICATION);
            String messageId = (String) event.get(EventTableDefine.MESSAGE_ID);
            String message = (String) event.get(EventTableDefine.MESSAGE);
            Integer confirmFlg = Integer.valueOf((String) event
                    .get(EventTableDefine.CONFIRMED));
            String confirmUser = (String) event
                    .get(EventTableDefine.CONFIRM_USER);

            EventLogData eventLogData = new EventLogData();
            eventLogData.setPriority(priority);
            eventLogData.setOutputDate(outputDate);
            eventLogData.setGenerationDate(generationDate);
            eventLogData.setPluginId(pluginId);
            eventLogData.setMonitorId(monitorId);
            eventLogData.setFacilityId(facilityId);
            eventLogData.setScopeText(scopeText);
            eventLogData.setApplication(application);
            eventLogData.setMessageId(messageId);
            eventLogData.setMessage(message);
            eventLogData.setConfirmFlg(confirmFlg);
            eventLogData.setConfirmUser(confirmUser);

            eventLogDataList.add(eventLogData);

        }

        return eventLogDataList;

    }
}
