/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.servlet;

/**
 * 監視[スコープ]ビューの一覧情報を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、スコープ一覧情報を取得します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jnp.interfaces.NamingContext;

import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.monitor.business.GetScopeListBusiness;
import com.necsoft.hinemos.webclient.monitor.form.MonitorScopeForm;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * スコープ情報データをリフレッシュするクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetScopeListServlet extends CommonServlet {
    private static final long serialVersionUID = -7775038566425028930L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetScopeListServlet.class);

    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        CommonJson result = new CommonJson();

        try {
            // NammingContextを取得する
            NamingContext namingContext = doLoadNamingContext(request);

            // 中間変数を宣言
            ArrayList<ArrayList<Object>> listInfoData = doLoadListInfoData(request,
                    namingContext);

            // Create JSON
            result = doConvertToJson(listInfoData, request.getLocale());

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }
        return result;
    }

    /**
     * @param request
     * @param namingContext
     * @return
     * @throws HinemosWebException
     */
    private ArrayList<ArrayList<Object>> doLoadListInfoData(HttpServletRequest request,
            NamingContext namingContext) throws HinemosWebException {
        // スコープ情報一覧データ(ScopeInfoData)を取得
        MonitorScopeForm form = new MonitorScopeForm();
        PopulateBeanUtils.populateBean(form, request);
        GetScopeListBusiness business = new GetScopeListBusiness();
        return business.getScopeList(form, namingContext);
    }

    /**
     * @param listInfoData
     * @param locale
     * @return
     */
    private GridDataJson doConvertToJson(ArrayList<ArrayList<Object>> listInfoData,
            Locale locale) {
        GetScopeListBusiness business = new GetScopeListBusiness();
        return business.doConvertToJson(listInfoData, locale);
    }
}