/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.clustercontrol.monitor.bean.EventTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.CssClass;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.monitor.business.GetEventListTableDefineBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * GetEventListTableDefineServlet
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetEventListTableDefineServlet extends CommonServlet {
    private static final long serialVersionUID = -3895758389407649269L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetEventListTableDefineServlet.class);

    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        CommonJson result = new CommonJson();

        try {
            ArrayList<TableColumnInfoJs> tblDefine = getEventListTableDefine(request);
            setModelProperties(tblDefine);
            result = doConvertToJson(tblDefine, request.getLocale());
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }
        return result;
    }

    /**
     * @param request
     * @return
     * @throws HinemosWebException
     */
    private ArrayList<TableColumnInfoJs> getEventListTableDefine(
            HttpServletRequest request) throws HinemosWebException {
        GetEventListTableDefineBusiness business = new GetEventListTableDefineBusiness();
        ArrayList<TableColumnInfoJs> tblDefine = business
                .getEventListTableDefine(request.getLocale());
        return tblDefine;
    }

    /**
     * @param tblDefine
     */
    private void setModelProperties(ArrayList<TableColumnInfoJs> tblDefine) {
        // Set priority class
        TableColumnInfoJs priority = tblDefine.get(EventTableDefine.PRIORITY);
        priority.setClasses(CssClass.PRIORITY_CELL);
        priority.setFormatter(JsConstant.GRID_FMATTER_PRIORITY);

        TableColumnInfoJs scope = tblDefine.get(EventTableDefine.SCOPE);
        scope.setFormatter(JsConstant.GRID_FMATTER_SCOPE_TYPE);
        Map<String, Object> scopeFmtOpt = new HashMap<String, Object>();
        scopeFmtOpt.put(JsConstant.GRID_FMATTER_SCOPE_TYPE_POSITION,
                EventTableDefine.FACILITY_ID);
        scopeFmtOpt.put(JsConstant.GRID_FMATTER_SCOPE_TYPE_RESERVED, true);
        scope.setFormatoptions(scopeFmtOpt);

        TableColumnInfoJs receiveTime = tblDefine
                .get(EventTableDefine.RECEIVE_TIME);
        receiveTime.setFormatter(JsConstant.GRID_FMATTER_DATE_TIME_PRECISE);
        receiveTime.setClasses(CssClass.GRID_MARKER_CELL_DATE_TIME_PRECISE);

        TableColumnInfoJs outputDate = tblDefine
                .get(EventTableDefine.OUTPUT_DATE);
        outputDate.setFormatter(JsConstant.GRID_FMATTER_DATE_TIME_PRECISE);
        outputDate.setClasses(CssClass.GRID_MARKER_CELL_DATE_TIME_PRECISE);

        tblDefine.get(EventTableDefine.CONFIRMED).setFormatter(
                JsConstant.GRID_FMATTER_CONFIRM_TYPE);
    }

    /**
     * @param tblDefine
     * @param locale
     * @return
     */
    private CommonJson doConvertToJson(ArrayList<TableColumnInfoJs> tblDefine,
            Locale locale) {
        GetEventListTableDefineBusiness business = new GetEventListTableDefineBusiness();
        return business.doConvertToJson(tblDefine, locale);
    }
}
