/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.util.PropertyUtil;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.monitor.util.EjbConnectionManager;

/**
 * イベント情報取得するクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetFilterEvent {

    // namingContextを定義
    private NamingContext m_namingContext = null;

    /**
     * namingContextを設定
     * 
     * @param namingContext
     * @return void
     */
    public void setNamingContext(NamingContext namingContext) {
        this.m_namingContext = namingContext;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、イベント一覧情報を取得します。
     * 
     * @param facilityId
     *            取得対象の親ファシリティID
     * @param messages
     *            表示イベント数
     * @param NullPointerException
     * @return ビュー一覧情報
     * @throws HinemosWebException
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getEventList(java.lang.String,
     *      int)
     */
    public ArrayList<ArrayList<Object>> getFilterInfo(String facilityId,
            int messages) throws HinemosWebException {

        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        MonitorController monitor = ejbConnectionManager.getMonitorController();

        ViewListInfo records = null;

        try {
            records = monitor.getEventList(facilityId, messages);
        } catch (AccessException e) {
            // アクセス権なしの場合、エラーダイアログを表示する
            throw new HinemosWebAccessException(
                    "exception.monitor.event.access", e);
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException(
                    "exception.monitor.event.remote", e);
        } catch (CreateException e) {
            throw new HinemosWebException("exception.monitor.event.action", e);
        } catch (FinderException e) {
            throw new HinemosWebException("exception.monitor.event.action", e);
        } catch (NamingException e) {
            throw new HinemosWebException("exception.monitor.event.action", e);
        } catch (SQLException e) {
            throw new HinemosWebException("exception.monitor.event.action", e);
        }

        if (records == null) {
            return null;
        }

        ArrayList<ArrayList<Object>> list = ConvertListUtil
                .eventLogDataListToArrayList(records.getList());

        return list;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、引数で指定された条件に一致するイベント一覧情報を返します。
     * 
     * @param facilityId
     *            取得対象の親ファシリティID
     * @param condition
     *            検索条件
     * @param messages
     *            表示イベント数
     * @return ビュー一覧情報
     * @throws HinemosWebException
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getEventList(String,
     *      Property, int)
     */
    public ArrayList<ArrayList<Object>> getFilterInfo(String facilityId,
            Property condition, int messages) throws HinemosWebException {

        PropertyUtil.deletePropertyDefine(condition);

        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        MonitorController monitor = ejbConnectionManager.getMonitorController();

        ViewListInfo records = null;

        if (monitor == null) {
            return null;
        }

        try {
            records = monitor.getEventList(facilityId, condition, messages);
        } catch (AccessException e) {
            // アクセス権なしの場合、エラーダイアログを表示する
            throw new HinemosWebAccessException(
                    "exception.monitor.event.access", e);
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException(
                    "exception.monitor.event.remote", e);
        } catch (CreateException e) {
            throw new HinemosWebException("exception.monitor.event.action", e);
        } catch (FinderException e) {
            throw new HinemosWebException("exception.monitor.event.action", e);
        } catch (NamingException e) {
            throw new HinemosWebException("exception.monitor.event.action", e);
        } catch (SQLException e) {
            throw new HinemosWebException("exception.monitor.event.action", e);
        }

        if (records == null) {
            return null;
        }

        ArrayList<ArrayList<Object>> list = ConvertListUtil
                .eventLogDataListToArrayList(records.getList());

        records.setList(list);

        return list;
    }
}