/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.monitor.util.EjbConnectionManager;

/**
 * イベント詳細情報表示用プロパティを取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、イベント詳細情報表示用プロパティを取得します。
 * 
 */
public class GetEventInfoProperty {

    // ----- instance メソッド ----- //
    // namingContextを定義
    private NamingContext m_namingContext = null;

    /**
     * namingContextを設定
     * 
     * @param namingContext
     * @return void
     */
    public void setNamingContext(NamingContext namingContext) {
        this.m_namingContext = namingContext;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、引数で指定されたイベント情報のイベント詳細情報表示用プロパティを取得します。
     * <p>
     * 指定されたリスト（{@link ArrayList}）には、１イベント情報の各値が、 テーブルのカラム順（
     * {@link com.clustercontrol.monitor.bean.EventTableDefine}）に格納されています。
     * <p>
     * <dl>
     * <dt>イベント情報</dt>
     * <dd>{ カラム1の値, カラム2の値, … }</dd>
     * </dl>
     * 
     * @param list
     *            取得対象のイベント情報
     * @return イベント詳細情報表示用プロパティ
     * @throws HinemosWebException
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getEventInfoProperty(String,
     *      String, String, Date, Locale)
     */
    public Property getProperty(String monitorId, String pluginId,
            String facilityId, Date receiveTime, Locale locale)
            throws HinemosWebException {

        Property property = null;

        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        MonitorController monitor = ejbConnectionManager.getMonitorController();
        try {
            property = monitor.getEventInfoProperty(monitorId, pluginId,
                    facilityId, receiveTime, locale);
        } catch (AccessException e) {
            // アクセス権なしの場合、エラーダイアログを表示する
            throw new HinemosWebAccessException(
                    "exception.monitor.event.info.access", e);
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException(
                    "exception.monitor.event.info.remote", e);
        } catch (FinderException e) {
            throw new HinemosWebException(
                    "exception.monitor.event.info.action", e);
        } catch (NamingException e) {
            throw new HinemosWebException(
                    "exception.monitor.event.info.action", e);
        }

        return property;
    }
}